/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server.utils;

import com.google.common.io.Files;
import io.kcache.keta.KetaConfig;
import io.kcache.keta.KetaEngine;
import io.kcache.keta.leader.LeaderElector;
import io.kcache.keta.notifier.KetaNotifier;
import io.kcache.keta.notifier.Notifier;
import io.kcache.keta.server.KetaMain;
import io.kcache.keta.server.grpc.proxy.GrpcProxy;
import io.kcache.keta.server.leader.KetaLeaderElector;
import io.kcache.keta.utils.ClusterTestHarness;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteClusterTestHarness
extends ClusterTestHarness {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteClusterTestHarness.class);
    protected Properties props;
    protected String endpoints;
    private GrpcProxy<byte[], byte[]> proxy;
    private KetaLeaderElector elector;
    protected File tempDir;
    protected Integer serverPort;

    public RemoteClusterTestHarness() {
    }

    public RemoteClusterTestHarness(int numBrokers) {
        super(numBrokers);
    }

    public KetaMain createKeta() throws Exception {
        this.props = new Properties();
        this.endpoints = "http://127.0.0.1:" + RemoteClusterTestHarness.choosePort();
        this.proxy = (GrpcProxy)Mockito.mock(GrpcProxy.class);
        this.elector = (KetaLeaderElector)Mockito.mock(KetaLeaderElector.class);
        Mockito.when((Object)this.elector.isLeader()).thenReturn((Object)true);
        Mockito.when((Object)this.elector.getListeners()).thenReturn(Collections.singletonList(new URI(this.endpoints)));
        return new KetaMain(new KetaConfig((Map)this.props), this.proxy, this.elector);
    }

    @BeforeEach
    public void setUp(Vertx vertx) throws Exception {
        super.setUp();
        if (this.tempDir == null) {
            this.tempDir = Files.createTempDir();
        }
        this.setUpServer(vertx);
    }

    private void setUpServer(Vertx vertx) {
        try {
            this.serverPort = RemoteClusterTestHarness.choosePort();
            this.injectKetaProperties(this.props);
            KetaConfig config = new KetaConfig((Map)this.props);
            KetaEngine engine = KetaEngine.getInstance();
            engine.configure(config);
            engine.init((LeaderElector)this.elector, (Notifier)new KetaNotifier(vertx.eventBus()));
        }
        catch (Exception e) {
            LOG.error("Server died unexpectedly: ", (Throwable)e);
            System.exit(1);
        }
    }

    protected void injectKetaProperties(Properties props) {
        props.put("listeners", "http://0.0.0.0:" + this.serverPort);
        props.put("kafkacache.bootstrap.servers", this.bootstrapServers);
        props.put("kafkacache.data.dir", this.tempDir.getAbsolutePath());
    }

    public static int[] choosePorts(int count) {
        try {
            int i;
            ServerSocket[] sockets = new ServerSocket[count];
            int[] ports = new int[count];
            for (i = 0; i < count; ++i) {
                sockets[i] = new ServerSocket(0, 0, InetAddress.getByName("0.0.0.0"));
                ports[i] = sockets[i].getLocalPort();
            }
            for (i = 0; i < count; ++i) {
                sockets[i].close();
            }
            return ports;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int choosePort() {
        return RemoteClusterTestHarness.choosePorts(1)[0];
    }

    @AfterEach
    public void tearDown() throws Exception {
        try {
            KetaEngine.closeInstance();
            FileUtils.deleteDirectory((File)this.tempDir);
        }
        catch (Exception e) {
            LOG.warn("Exception during tearDown", (Throwable)e);
        }
        super.tearDown();
    }
}

