/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server;

import com.google.common.base.Charsets;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import io.etcd.jetcd.lease.LeaseTimeToLiveResponse;
import io.etcd.jetcd.options.LeaseOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.support.CloseableClient;
import io.etcd.jetcd.support.Observers;
import io.grpc.stub.StreamObserver;
import io.kcache.keta.server.utils.RemoteClusterTestHarness;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class LeaseTest
extends RemoteClusterTestHarness {
    private KV kvClient;
    private Client client;
    private Lease leaseClient;
    private static final ByteSequence KEY = ByteSequence.from((String)"foo", (Charset)Charsets.UTF_8);
    private static final ByteSequence KEY_2 = ByteSequence.from((String)"foo2", (Charset)Charsets.UTF_8);
    private static final ByteSequence VALUE = ByteSequence.from((String)"bar", (Charset)Charsets.UTF_8);

    @BeforeAll
    public void deployVerticle(Vertx vertx, VertxTestContext testContext) throws Exception {
        vertx.deployVerticle((Verticle)this.createKeta(), testContext.completing());
        this.client = Client.builder().endpoints(new String[]{this.endpoints}).build();
        this.kvClient = this.client.getKVClient();
        this.leaseClient = this.client.getLeaseClient();
    }

    @Override
    @BeforeEach
    public void setUp(Vertx vertx) throws Exception {
        super.setUp(vertx);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGrant() throws Exception {
        long leaseID = ((LeaseGrantResponse)this.leaseClient.grant(5L).get()).getID();
        this.kvClient.put(KEY, VALUE, PutOption.newBuilder().withLeaseId(leaseID).build()).get();
        Assertions.assertThat((long)((GetResponse)this.kvClient.get(KEY).get()).getCount()).isEqualTo(1L);
        Thread.sleep(6000L);
        Assertions.assertThat((long)((GetResponse)this.kvClient.get(KEY).get()).getCount()).isEqualTo(0L);
    }

    @Test
    public void testGrantWithTimeout() throws Exception {
        long leaseID = ((LeaseGrantResponse)this.leaseClient.grant(5L, 10L, TimeUnit.SECONDS).get()).getID();
        this.kvClient.put(KEY, VALUE, PutOption.newBuilder().withLeaseId(leaseID).build()).get();
        Assertions.assertThat((long)((GetResponse)this.kvClient.get(KEY).get()).getCount()).isEqualTo(1L);
        Thread.sleep(6000L);
        Assertions.assertThat((long)((GetResponse)this.kvClient.get(KEY).get()).getCount()).isEqualTo(0L);
        this.tearDown();
        Assertions.assertThatExceptionOfType(ExecutionException.class).isThrownBy(() -> ((LeaseGrantResponse)this.leaseClient.grant(5L, 2L, TimeUnit.SECONDS).get()).getID());
        this.setUp();
    }

    @Test
    public void testRevoke() throws Exception {
        long leaseID = ((LeaseGrantResponse)this.leaseClient.grant(5L).get()).getID();
        this.kvClient.put(KEY, VALUE, PutOption.newBuilder().withLeaseId(leaseID).build()).get();
        Assertions.assertThat((long)((GetResponse)this.kvClient.get(KEY).get()).getCount()).isEqualTo(1L);
        this.leaseClient.revoke(leaseID).get();
        Assertions.assertThat((long)((GetResponse)this.kvClient.get(KEY).get()).getCount()).isEqualTo(0L);
    }

    @Test
    public void testKeepAliveOnce() throws ExecutionException, InterruptedException {
        long leaseID = ((LeaseGrantResponse)this.leaseClient.grant(2L).get()).getID();
        this.kvClient.put(KEY, VALUE, PutOption.newBuilder().withLeaseId(leaseID).build()).get();
        Assertions.assertThat((long)((GetResponse)this.kvClient.get(KEY).get()).getCount()).isEqualTo(1L);
        LeaseKeepAliveResponse rp = (LeaseKeepAliveResponse)this.leaseClient.keepAliveOnce(leaseID).get();
        Assertions.assertThat((long)rp.getTTL()).isGreaterThan(0L);
    }

    @Test
    public void testKeepAlive() throws ExecutionException, InterruptedException {
        long leaseID = ((LeaseGrantResponse)this.leaseClient.grant(2L).get()).getID();
        this.kvClient.put(KEY, VALUE, PutOption.newBuilder().withLeaseId(leaseID).build()).get();
        Assertions.assertThat((long)((GetResponse)this.kvClient.get(KEY).get()).getCount()).isEqualTo(1L);
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference responseRef = new AtomicReference();
        StreamObserver observer = Observers.observer(response -> {
            responseRef.set(response);
            latch.countDown();
        });
        try (CloseableClient c = this.leaseClient.keepAlive(leaseID, observer);){
            latch.await(5L, TimeUnit.SECONDS);
            LeaseKeepAliveResponse response2 = (LeaseKeepAliveResponse)responseRef.get();
            Assertions.assertThat((long)response2.getTTL()).isGreaterThan(0L);
        }
        Thread.sleep(3000L);
        Assertions.assertThat((long)((GetResponse)this.kvClient.get(KEY).get()).getCount()).isEqualTo(0L);
    }

    @Test
    public void testTimeToLive() throws ExecutionException, InterruptedException {
        long ttl = 5L;
        long leaseID = ((LeaseGrantResponse)this.leaseClient.grant(ttl).get()).getID();
        LeaseTimeToLiveResponse resp = (LeaseTimeToLiveResponse)this.leaseClient.timeToLive(leaseID, LeaseOption.DEFAULT).get();
        Assertions.assertThat((long)resp.getTTl()).isGreaterThan(0L);
        Assertions.assertThat((long)resp.getGrantedTTL()).isEqualTo(ttl);
    }

    @Test
    public void testTimeToLiveWithKeys() throws ExecutionException, InterruptedException {
        long ttl = 5L;
        long leaseID = ((LeaseGrantResponse)this.leaseClient.grant(ttl).get()).getID();
        PutOption putOption = PutOption.newBuilder().withLeaseId(leaseID).build();
        this.kvClient.put(KEY_2, VALUE, putOption).get();
        LeaseOption leaseOption = LeaseOption.newBuilder().withAttachedKeys().build();
        LeaseTimeToLiveResponse resp = (LeaseTimeToLiveResponse)this.leaseClient.timeToLive(leaseID, leaseOption).get();
        Assertions.assertThat((long)resp.getTTl()).isGreaterThan(0L);
        Assertions.assertThat((long)resp.getGrantedTTL()).isEqualTo(ttl);
        Assertions.assertThat((int)resp.getKeys().size()).isEqualTo(1);
        Assertions.assertThat(resp.getKeys().get(0)).isEqualTo((Object)KEY_2);
    }
}

