/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server;

import io.etcd.jetcd.Auth;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.auth.AuthRoleGetResponse;
import io.etcd.jetcd.auth.AuthRoleListResponse;
import io.etcd.jetcd.auth.AuthUserGetResponse;
import io.etcd.jetcd.auth.AuthUserListResponse;
import io.etcd.jetcd.auth.Permission;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.PutResponse;
import io.kcache.keta.server.utils.RemoteClusterTestHarness;
import io.kcache.keta.server.utils.TestUtils;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class AuthClientTest
extends RemoteClusterTestHarness {
    private final ByteSequence rootRoleKey = TestUtils.bytesOf("root");
    private final ByteSequence rootRoleValue = TestUtils.bytesOf("b");
    private final ByteSequence rootRoleKeyRangeBegin = TestUtils.bytesOf("root");
    private final ByteSequence rootRoleKeyRangeEnd = TestUtils.bytesOf("root1");
    private final ByteSequence userRoleKey = TestUtils.bytesOf("foo");
    private final ByteSequence userRoleValue = TestUtils.bytesOf("bar");
    private final ByteSequence userRoleKeyRangeBegin = TestUtils.bytesOf("foo");
    private final ByteSequence userRoleKeyRangeEnd = TestUtils.bytesOf("foo1");
    private final String rootString = "root";
    private final ByteSequence root = TestUtils.bytesOf("root");
    private final ByteSequence rootPass = TestUtils.bytesOf("123");
    private final String rootRoleString = "root";
    private final ByteSequence rootRole = TestUtils.bytesOf("root");
    private final String userString = "user";
    private final ByteSequence user = TestUtils.bytesOf("user");
    private final ByteSequence userPass = TestUtils.bytesOf("userPass");
    private final ByteSequence userNewPass = TestUtils.bytesOf("newUserPass");
    private final String userRoleString = "userRole";
    private final ByteSequence userRole = TestUtils.bytesOf("userRole");
    private static Auth authDisabledAuthClient;
    private static KV authDisabledKVClient;

    @BeforeAll
    public void deployVerticle(Vertx vertx, VertxTestContext testContext) throws Exception {
        vertx.deployVerticle((Verticle)this.createKeta(), testContext.completing());
        Client client = Client.builder().endpoints(new String[]{this.endpoints}).build();
        authDisabledKVClient = client.getKVClient();
        authDisabledAuthClient = client.getAuthClient();
    }

    @Test
    public void testAuth() throws Exception {
        authDisabledAuthClient.roleAdd(this.rootRole).get();
        authDisabledAuthClient.roleAdd(this.userRole).get();
        AuthRoleListResponse response = (AuthRoleListResponse)authDisabledAuthClient.roleList().get();
        Assertions.assertThat((List)response.getRoles()).containsOnly((Object[])new String[]{"root", "userRole"});
        authDisabledAuthClient.roleGrantPermission(this.rootRole, this.rootRoleKeyRangeBegin, this.rootRoleKeyRangeEnd, Permission.Type.READWRITE).get();
        authDisabledAuthClient.roleGrantPermission(this.userRole, this.userRoleKeyRangeBegin, this.userRoleKeyRangeEnd, Permission.Type.READWRITE).get();
        authDisabledAuthClient.userAdd(this.root, this.rootPass).get();
        authDisabledAuthClient.userAdd(this.user, this.userPass).get();
        authDisabledAuthClient.userChangePassword(this.user, this.userNewPass).get();
        List users = ((AuthUserListResponse)authDisabledAuthClient.userList().get()).getUsers();
        Assertions.assertThat((List)users).containsOnly((Object[])new String[]{"root", "user"});
        authDisabledAuthClient.userGrantRole(this.root, this.rootRole).get();
        authDisabledAuthClient.userGrantRole(this.user, this.rootRole).get();
        authDisabledAuthClient.userGrantRole(this.user, this.userRole).get();
        Assertions.assertThat((List)((AuthUserGetResponse)authDisabledAuthClient.userGet(this.root).get()).getRoles()).containsOnly((Object[])new String[]{"root"});
        Assertions.assertThat((List)((AuthUserGetResponse)authDisabledAuthClient.userGet(this.user).get()).getRoles()).containsOnly((Object[])new String[]{"root", "userRole"});
        authDisabledAuthClient.authEnable().get();
        Client userClient = Client.builder().endpoints(new String[]{this.endpoints}).user(this.user).password(this.userNewPass).build();
        Client rootClient = Client.builder().endpoints(new String[]{this.endpoints}).user(this.root).password(this.rootPass).build();
        userClient.getKVClient().put(this.rootRoleKey, this.rootRoleValue).get();
        userClient.getKVClient().put(this.userRoleKey, this.userRoleValue).get();
        userClient.getKVClient().get(this.rootRoleKey).get();
        userClient.getKVClient().get(this.userRoleKey).get();
        Assertions.assertThatThrownBy(() -> {
            PutResponse cfr_ignored_0 = (PutResponse)authDisabledKVClient.put(this.rootRoleKey, this.rootRoleValue).get();
        }).hasMessageContaining("ketaserver: user name is empty");
        Assertions.assertThatThrownBy(() -> {
            PutResponse cfr_ignored_0 = (PutResponse)authDisabledKVClient.put(this.userRoleKey, this.rootRoleValue).get();
        }).hasMessageContaining("ketaserver: user name is empty");
        Assertions.assertThatThrownBy(() -> {
            GetResponse cfr_ignored_0 = (GetResponse)authDisabledKVClient.get(this.rootRoleKey).get();
        }).hasMessageContaining("ketaserver: user name is empty");
        Assertions.assertThatThrownBy(() -> {
            GetResponse cfr_ignored_0 = (GetResponse)authDisabledKVClient.get(this.userRoleKey).get();
        }).hasMessageContaining("ketaserver: user name is empty");
        AuthRoleGetResponse roleGetResponse = (AuthRoleGetResponse)userClient.getAuthClient().roleGet(this.rootRole).get();
        Assertions.assertThat((int)roleGetResponse.getPermissions().size()).isNotEqualTo(0);
        roleGetResponse = (AuthRoleGetResponse)userClient.getAuthClient().roleGet(this.userRole).get();
        Assertions.assertThat((int)roleGetResponse.getPermissions().size()).isNotEqualTo(0);
        rootClient.getAuthClient().userRevokeRole(this.user, this.rootRole).get();
        KV kvClient = userClient.getKVClient();
        Assertions.assertThatThrownBy(() -> {
            GetResponse cfr_ignored_0 = (GetResponse)kvClient.get(this.rootRoleKey).get();
        }).isNotNull();
        Assertions.assertThat((long)((GetResponse)kvClient.get(this.userRoleKey).get()).getCount()).isNotEqualTo(0L);
        rootClient.getAuthClient().roleRevokePermission(this.userRole, this.userRoleKeyRangeBegin, this.userRoleKeyRangeEnd).get();
        Assertions.assertThatThrownBy(() -> {
            GetResponse cfr_ignored_0 = (GetResponse)userClient.getKVClient().get(this.userRoleKey).get();
        }).isNotNull();
        rootClient.getAuthClient().authDisable().get();
        authDisabledAuthClient.userDelete(this.root).get();
        authDisabledAuthClient.userDelete(this.user).get();
        authDisabledAuthClient.roleDelete(this.rootRole).get();
        authDisabledAuthClient.roleDelete(this.userRole).get();
    }
}

