/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server.grpc.utils;

import io.grpc.netty.GrpcSslContexts;
import io.kcache.keta.KetaConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;

public class SslFactory {
    private final boolean isServer;
    private final String kmfAlgorithm;
    private final String tmfAlgorithm;
    private SecurityStore keystore = null;
    private Password keyPassword;
    private SecurityStore truststore;
    private final ClientAuth clientAuth;
    private SslContext sslContext;

    public SslFactory(KetaConfig config, boolean isServer) {
        this.isServer = isServer;
        this.kmfAlgorithm = config.getString("ssl.keymanager.algorithm");
        this.tmfAlgorithm = config.getString("ssl.trustmanager.algorithm");
        try {
            this.createKeystore(config.getString("ssl.keystore.type"), config.getString("ssl.keystore.location"), config.getPassword("ssl.keystore.password"), config.getPassword("ssl.key.password"));
            this.createTruststore(config.getString("ssl.truststore.type"), config.getString("ssl.truststore.location"), config.getPassword("ssl.truststore.password"));
            this.clientAuth = this.getClientAuth(config.getString("ssl.client.authentication"));
            this.sslContext = this.createSslContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing the ssl context for RestService", e);
        }
    }

    private static boolean isNotBlank(String str) {
        return str != null && !str.trim().isEmpty();
    }

    private SslContext createSslContext() throws GeneralSecurityException, IOException {
        if (this.keystore == null) {
            return null;
        }
        String kmfAlgorithm = SslFactory.isNotBlank(this.kmfAlgorithm) ? this.kmfAlgorithm : KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(kmfAlgorithm);
        KeyStore ks = this.keystore.load();
        Password keyPassword = this.keyPassword != null ? this.keyPassword : this.keystore.password;
        kmf.init(ks, keyPassword.value().toCharArray());
        SslContextBuilder sslContextBuilder = this.isServer ? SslContextBuilder.forServer((KeyManagerFactory)kmf) : SslContextBuilder.forClient().keyManager(kmf);
        if (this.truststore != null) {
            String tmfAlgorithm = SslFactory.isNotBlank(this.tmfAlgorithm) ? this.tmfAlgorithm : TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
            KeyStore ts = this.truststore.load();
            tmf.init(ts);
            sslContextBuilder.trustManager(tmf);
        }
        sslContextBuilder = sslContextBuilder.clientAuth(this.clientAuth);
        sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder);
        this.sslContext = sslContextBuilder.build();
        return this.sslContext;
    }

    private ClientAuth getClientAuth(String clientAuth) {
        switch (clientAuth) {
            case "NONE": {
                return ClientAuth.NONE;
            }
            case "REQUESTED": {
                return ClientAuth.OPTIONAL;
            }
            case "REQUIRED": {
                return ClientAuth.REQUIRE;
            }
        }
        throw new ConfigException("Unknown client auth: " + clientAuth);
    }

    public SslContext sslContext() {
        return this.sslContext;
    }

    private void createKeystore(String type, String path, Password password, Password keyPassword) {
        if (path == null && password != null) {
            throw new RuntimeException("SSL key store is not specified, but key store password is specified.");
        }
        if (path != null && password == null) {
            throw new RuntimeException("SSL key store is specified, but key store password is not specified.");
        }
        if (SslFactory.isNotBlank(path) && SslFactory.isNotBlank(password.value())) {
            this.keystore = new SecurityStore(type, path, password);
            this.keyPassword = keyPassword;
        }
    }

    private void createTruststore(String type, String path, Password password) {
        if (path == null && password != null) {
            throw new RuntimeException("SSL trust store is not specified, but trust store password is specified.");
        }
        if (SslFactory.isNotBlank(path)) {
            this.truststore = new SecurityStore(type, path, password);
        }
    }

    private static class SecurityStore {
        private final String type;
        private final String path;
        private final Password password;

        private SecurityStore(String type, String path, Password password) {
            this.type = type == null ? KeyStore.getDefaultType() : type;
            this.path = path;
            this.password = password;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KeyStore load() throws GeneralSecurityException, IOException {
            try (FileInputStream in = null;){
                KeyStore ks = KeyStore.getInstance(this.type);
                in = new FileInputStream(this.path);
                char[] passwordChars = this.password != null ? this.password.value().toCharArray() : null;
                ks.load(in, passwordChars);
                KeyStore keyStore = ks;
                return keyStore;
            }
        }
    }
}

