/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server.grpc.proxy;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.Status;
import java.io.InputStream;

public final class ProxyServerCallHandler<RequestT, ResponseT>
implements ServerCallHandler<InputStream, InputStream> {
    private final ServerMethodDefinition<RequestT, ResponseT> delegateMethod;
    private static final MethodDescriptor.Marshaller<InputStream> IDENTITY_MARSHALLER = new MethodDescriptor.Marshaller<InputStream>(){

        public InputStream stream(InputStream value) {
            return value;
        }

        public InputStream parse(InputStream stream) {
            return stream;
        }
    };

    public static <RequestT, ResponseT> ServerMethodDefinition<InputStream, InputStream> proxyMethod(ServerMethodDefinition<RequestT, ResponseT> delegateMethod) {
        MethodDescriptor delegateMethodDescriptor = delegateMethod.getMethodDescriptor();
        return ServerMethodDefinition.create((MethodDescriptor)MethodDescriptor.newBuilder().setType(delegateMethodDescriptor.getType()).setFullMethodName(delegateMethodDescriptor.getFullMethodName()).setRequestMarshaller(IDENTITY_MARSHALLER).setResponseMarshaller(IDENTITY_MARSHALLER).build(), new ProxyServerCallHandler<RequestT, ResponseT>(delegateMethod));
    }

    ProxyServerCallHandler(ServerMethodDefinition<RequestT, ResponseT> delegateMethod) {
        this.delegateMethod = delegateMethod;
    }

    public ServerCall.Listener<InputStream> startCall(ServerCall<InputStream, InputStream> call, Metadata headers) {
        ServerCall.Listener delegateListener = this.delegateMethod.getServerCallHandler().startCall((ServerCall)new ServerCallAdapter(call, this.delegateMethod.getMethodDescriptor()), headers);
        return new ServerCallListenerAdapter(delegateListener);
    }

    final class ServerCallAdapter
    extends ServerCall<RequestT, ResponseT> {
        private final ServerCall<InputStream, InputStream> delegate;
        private final MethodDescriptor<RequestT, ResponseT> method;

        ServerCallAdapter(ServerCall<InputStream, InputStream> delegate, MethodDescriptor<RequestT, ResponseT> method) {
            this.delegate = delegate;
            this.method = method;
        }

        public MethodDescriptor<RequestT, ResponseT> getMethodDescriptor() {
            return this.method;
        }

        public void request(int numMessages) {
            this.delegate.request(numMessages);
        }

        public void sendHeaders(Metadata headers) {
            this.delegate.sendHeaders(headers);
        }

        public void sendMessage(ResponseT message) {
            this.delegate.sendMessage((Object)ProxyServerCallHandler.this.delegateMethod.getMethodDescriptor().streamResponse(message));
        }

        public void close(Status status, Metadata trailers) {
            this.delegate.close(status, trailers);
        }

        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }
    }

    private final class ServerCallListenerAdapter
    extends ServerCall.Listener<InputStream> {
        private final ServerCall.Listener<RequestT> delegate;

        public ServerCallListenerAdapter(ServerCall.Listener<RequestT> delegate) {
            this.delegate = delegate;
        }

        public void onMessage(InputStream message) {
            this.delegate.onMessage(ProxyServerCallHandler.this.delegateMethod.getMethodDescriptor().parseRequest(message));
        }

        public void onHalfClose() {
            this.delegate.onHalfClose();
        }

        public void onCancel() {
            this.delegate.onCancel();
        }

        public void onComplete() {
            this.delegate.onComplete();
        }
    }
}

