/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server.grpc.proxy;

import com.google.common.io.ByteStreams;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.HandlerRegistry;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.kcache.keta.KetaConfig;
import io.kcache.keta.server.grpc.proxy.ProxyServerCallHandler;
import io.kcache.keta.server.grpc.utils.SslFactory;
import io.kcache.keta.server.leader.KetaIdentity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcProxy<ReqT, RespT>
implements ServerCallHandler<ReqT, RespT> {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcProxy.class);
    private KetaConfig config;
    private KetaIdentity target;
    private ManagedChannel channel;

    public GrpcProxy(KetaConfig config, KetaIdentity target) {
        this.config = config;
        this.setTarget(target);
    }

    public synchronized KetaIdentity getTarget() {
        return this.target;
    }

    public synchronized void setTarget(KetaIdentity target) {
        if (!Objects.equals(this.target, target)) {
            if (this.channel != null) {
                LOG.info("Shutting down channel");
                this.channel.shutdown();
                this.channel = null;
            }
            if (target != null) {
                LOG.info("Setting up proxy to {}", (Object)target);
                NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)target.getHost(), (int)target.getPort());
                if (target.isSecure()) {
                    builder.negotiationType(NegotiationType.TLS).sslContext(new SslFactory(this.config, false).sslContext());
                } else {
                    builder.negotiationType(NegotiationType.PLAINTEXT);
                }
                this.channel = builder.build();
            }
            this.target = target;
        }
    }

    public synchronized ManagedChannel getChannel() {
        return this.channel;
    }

    public ServerCall.Listener<ReqT> startCall(ServerCall<ReqT, RespT> serverCall, Metadata headers) {
        ClientCall clientCall = this.getChannel().newCall(serverCall.getMethodDescriptor(), CallOptions.DEFAULT);
        CallProxy<ReqT, RespT> proxy = new CallProxy<ReqT, RespT>(serverCall, clientCall);
        clientCall.start((ClientCall.Listener)proxy.clientCallListener, headers);
        serverCall.request(1);
        clientCall.request(1);
        return proxy.serverCallListener;
    }

    public static class Registry
    extends HandlerRegistry {
        private final MethodDescriptor.Marshaller<byte[]> byteMarshaller = new ByteMarshaller();
        private final GrpcProxy<byte[], byte[]> proxy;
        private final Map<String, ServerMethodDefinition<?, ?>> methods = new HashMap();

        public Registry(GrpcProxy<byte[], byte[]> proxy, List<ServerServiceDefinition> services) {
            this.proxy = proxy;
            for (ServerServiceDefinition service : services) {
                for (ServerMethodDefinition method : service.getMethods()) {
                    this.methods.put(method.getMethodDescriptor().getFullMethodName(), method);
                }
            }
        }

        public ServerMethodDefinition<?, ?> lookupMethod(String methodName, String authority) {
            if (this.proxy == null || this.proxy.getTarget() == null) {
                LOG.info("Serving {}", (Object)methodName);
                return ProxyServerCallHandler.proxyMethod(this.methods.get(methodName));
            }
            LOG.info("Proxying {} to {}", (Object)methodName, (Object)this.proxy.getTarget());
            MethodDescriptor methodDescriptor = MethodDescriptor.newBuilder(this.byteMarshaller, this.byteMarshaller).setFullMethodName(methodName).setType(MethodDescriptor.MethodType.UNKNOWN).build();
            return ServerMethodDefinition.create((MethodDescriptor)methodDescriptor, this.proxy);
        }
    }

    private static class ByteMarshaller
    implements MethodDescriptor.Marshaller<byte[]> {
        private ByteMarshaller() {
        }

        public byte[] parse(InputStream stream) {
            try {
                return ByteStreams.toByteArray((InputStream)stream);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public InputStream stream(byte[] value) {
            return new ByteArrayInputStream(value);
        }
    }

    private static class CallProxy<ReqT, RespT> {
        final RequestProxy serverCallListener;
        final ResponseProxy clientCallListener;

        public CallProxy(ServerCall<ReqT, RespT> serverCall, ClientCall<ReqT, RespT> clientCall) {
            this.serverCallListener = new RequestProxy(clientCall);
            this.clientCallListener = new ResponseProxy(serverCall);
        }

        private class ResponseProxy
        extends ClientCall.Listener<RespT> {
            private final ServerCall<?, RespT> serverCall;
            private boolean needToRequest;

            public ResponseProxy(ServerCall<?, RespT> serverCall) {
                this.serverCall = serverCall;
            }

            public void onClose(Status status, Metadata trailers) {
                this.serverCall.close(status, trailers);
            }

            public void onHeaders(Metadata headers) {
                this.serverCall.sendHeaders(headers);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(RespT message) {
                this.serverCall.sendMessage(message);
                ResponseProxy responseProxy = this;
                synchronized (responseProxy) {
                    if (this.serverCall.isReady()) {
                        CallProxy.this.serverCallListener.clientCall.request(1);
                    } else {
                        this.needToRequest = true;
                    }
                }
            }

            public void onReady() {
                CallProxy.this.serverCallListener.onClientReady();
            }

            synchronized void onServerReady() {
                if (this.needToRequest) {
                    CallProxy.this.serverCallListener.clientCall.request(1);
                    this.needToRequest = false;
                }
            }
        }

        private class RequestProxy
        extends ServerCall.Listener<ReqT> {
            private final ClientCall<ReqT, ?> clientCall;
            private boolean needToRequest;

            public RequestProxy(ClientCall<ReqT, ?> clientCall) {
                this.clientCall = clientCall;
            }

            public void onCancel() {
                this.clientCall.cancel("Server cancelled", null);
            }

            public void onHalfClose() {
                this.clientCall.halfClose();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(ReqT message) {
                this.clientCall.sendMessage(message);
                RequestProxy requestProxy = this;
                synchronized (requestProxy) {
                    if (this.clientCall.isReady()) {
                        CallProxy.this.clientCallListener.serverCall.request(1);
                    } else {
                        this.needToRequest = true;
                    }
                }
            }

            public void onReady() {
                CallProxy.this.clientCallListener.onServerReady();
            }

            synchronized void onClientReady() {
                if (this.needToRequest) {
                    CallProxy.this.clientCallListener.serverCall.request(1);
                    this.needToRequest = false;
                }
            }
        }
    }
}

