/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.keta.server.grpc;

import com.google.protobuf.ByteString;
import io.etcd.jetcd.api.CompactionRequest;
import io.etcd.jetcd.api.CompactionResponse;
import io.etcd.jetcd.api.Compare;
import io.etcd.jetcd.api.DeleteRangeRequest;
import io.etcd.jetcd.api.DeleteRangeResponse;
import io.etcd.jetcd.api.KVGrpc;
import io.etcd.jetcd.api.PutRequest;
import io.etcd.jetcd.api.PutResponse;
import io.etcd.jetcd.api.RangeRequest;
import io.etcd.jetcd.api.RangeResponse;
import io.etcd.jetcd.api.RequestOp;
import io.etcd.jetcd.api.ResponseHeader;
import io.etcd.jetcd.api.ResponseOp;
import io.etcd.jetcd.api.TxnRequest;
import io.etcd.jetcd.api.TxnResponse;
import io.grpc.stub.StreamObserver;
import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import io.kcache.keta.KetaEngine;
import io.kcache.keta.auth.KetaAuthManager;
import io.kcache.keta.lease.KetaLeaseManager;
import io.kcache.keta.lease.LeaseKeys;
import io.kcache.keta.pb.VersionedValue;
import io.kcache.keta.server.grpc.errors.KetaErrorType;
import io.kcache.keta.server.grpc.errors.KetaException;
import io.kcache.keta.server.grpc.utils.AuthServerInterceptor;
import io.kcache.keta.server.grpc.utils.GrpcUtils;
import io.kcache.keta.server.leader.KetaLeaderElector;
import io.kcache.keta.transaction.client.KetaTransaction;
import io.kcache.keta.transaction.client.KetaTransactionManager;
import io.kcache.keta.utils.ProtoUtils;
import io.kcache.keta.version.TxVersionedCache;
import io.kcache.keta.version.VersionedCache;
import java.util.ArrayList;
import java.util.List;
import org.apache.omid.transaction.Transaction;
import org.apache.omid.transaction.TransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVService
extends KVGrpc.KVImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(KVService.class);
    private final KetaLeaderElector elector;

    public KVService(KetaLeaderElector elector) {
        this.elector = elector;
    }

    @Override
    public void range(RangeRequest request, StreamObserver<RangeResponse> responseObserver) {
        if (!KetaEngine.getInstance().isLeader()) {
            responseObserver.onError((Throwable)KetaErrorType.LeaderChanged.toException());
            return;
        }
        LOG.info("Range request: [{}, {})", (Object)request.getKey(), (Object)request.getRangeEnd());
        KetaTransactionManager txMgr = KetaEngine.getInstance().getTxManager();
        Transaction tx = null;
        try {
            tx = txMgr.begin();
            RangeResponse response = this.doRange(request);
            txMgr.commit(tx);
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
            LOG.info("Range success: [{}, {})", (Object)request.getKey(), (Object)request.getRangeEnd());
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    txMgr.rollback(tx);
                }
                catch (TransactionException transactionException) {
                    // empty catch block
                }
            }
            responseObserver.onError((Throwable)GrpcUtils.toStatusException(e));
        }
    }

    private RangeResponse doRange(RangeRequest request) {
        KetaAuthManager authMgr = KetaEngine.getInstance().getAuthManager();
        authMgr.checkRangePermitted((String)AuthServerInterceptor.USER_CTX_KEY.get(), request.getKey(), request.getRangeEnd());
        TxVersionedCache cache = KetaEngine.getInstance().getTxCache();
        byte[] from = request.getKey().toByteArray();
        if (from.length == 0) {
            throw new KetaException(KetaErrorType.EmptyKey);
        }
        byte[] to = request.getRangeEnd().toByteArray();
        boolean descending = request.getSortOrder() == RangeRequest.SortOrder.DESCEND;
        boolean keysOnly = request.getKeysOnly();
        boolean countOnly = request.getCountOnly();
        long limit = request.getLimit();
        RangeResponse.Builder responseBuilder = RangeResponse.newBuilder();
        responseBuilder.setHeader(this.toResponseHeader());
        if (to.length == 0) {
            VersionedValue versioned = cache.get(from);
            if (versioned != null) {
                io.etcd.jetcd.api.KeyValue kv = ProtoUtils.toKeyValue((byte[])from, (VersionedValue)versioned);
                responseBuilder.addKvs(kv);
                responseBuilder.setCount(1L);
            }
        } else {
            if (to.length == 1 && to[0] == 0) {
                to = null;
            }
            long count = 0L;
            try (KeyValueIterator iter = cache.range(from, true, to, false, descending);){
                while (iter.hasNext()) {
                    KeyValue entry = (KeyValue)iter.next();
                    if (!countOnly) {
                        io.etcd.jetcd.api.KeyValue kv = ProtoUtils.toKeyValue((byte[])((byte[])entry.key), (VersionedValue)((VersionedValue)entry.value), (boolean)keysOnly);
                        responseBuilder.addKvs(kv);
                    }
                    if (limit <= 0L || ++count != limit) continue;
                    responseBuilder.setMore(iter.hasNext());
                    break;
                }
            }
            responseBuilder.setCount(count);
        }
        return responseBuilder.build();
    }

    @Override
    public void put(PutRequest request, StreamObserver<PutResponse> responseObserver) {
        if (!KetaEngine.getInstance().isLeader()) {
            responseObserver.onError((Throwable)KetaErrorType.LeaderChanged.toException());
            return;
        }
        LOG.info("Put request: {}", (Object)request.getKey());
        KetaTransactionManager txMgr = KetaEngine.getInstance().getTxManager();
        Transaction tx = null;
        try {
            tx = txMgr.begin();
            PutResponse response = this.doPut(request);
            txMgr.commit(tx);
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
            LOG.info("Put success: {}", (Object)request.getKey());
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    txMgr.rollback(tx);
                }
                catch (TransactionException transactionException) {
                    // empty catch block
                }
            }
            responseObserver.onError((Throwable)GrpcUtils.toStatusException(e));
        }
    }

    private PutResponse doPut(PutRequest request) {
        LeaseKeys lk;
        long oldLease;
        KetaAuthManager authMgr = KetaEngine.getInstance().getAuthManager();
        authMgr.checkPutPermitted((String)AuthServerInterceptor.USER_CTX_KEY.get(), request.getKey());
        TxVersionedCache cache = KetaEngine.getInstance().getTxCache();
        KetaLeaseManager leaseMgr = KetaEngine.getInstance().getLeaseManager();
        byte[] key = request.getKey().toByteArray();
        if (key.length == 0) {
            throw new KetaException(KetaErrorType.EmptyKey);
        }
        byte[] value = request.getValue().toByteArray();
        long lease = request.getLease();
        this.checkLeasePuts(lease);
        boolean ignoreValue = request.getIgnoreValue();
        boolean ignoreLease = request.getIgnoreLease();
        if (ignoreValue && value.length != 0) {
            throw new KetaException(KetaErrorType.ValueProvided);
        }
        if (ignoreLease && lease != 0L) {
            throw new KetaException(KetaErrorType.LeaseProvided);
        }
        VersionedValue versioned = cache.put(key, value, lease, ignoreValue, ignoreLease);
        long l = oldLease = versioned != null ? versioned.getLease() : 0L;
        if (oldLease > 0L) {
            lk = leaseMgr.get(oldLease);
            lk.getKeys().remove(request.getKey());
        }
        if (lease > 0L) {
            lk = leaseMgr.get(lease);
            lk.getKeys().add(request.getKey());
        }
        PutResponse.Builder responseBuilder = PutResponse.newBuilder();
        responseBuilder.setHeader(this.toResponseHeader());
        if (request.getPrevKv() && versioned != null) {
            authMgr.checkRangePermitted((String)AuthServerInterceptor.USER_CTX_KEY.get(), request.getKey(), null);
            io.etcd.jetcd.api.KeyValue kv = ProtoUtils.toKeyValue((byte[])key, (VersionedValue)versioned);
            responseBuilder.setPrevKv(kv);
        }
        return responseBuilder.build();
    }

    private void checkLeasePuts(long lease) {
        if (lease == 0L) {
            return;
        }
        KetaLeaseManager leaseMgr = KetaEngine.getInstance().getLeaseManager();
        LeaseKeys lk = leaseMgr.get(lease);
        KetaAuthManager authMgr = KetaEngine.getInstance().getAuthManager();
        if (lk != null) {
            for (ByteString key : lk.getKeys()) {
                authMgr.checkPutPermitted((String)AuthServerInterceptor.USER_CTX_KEY.get(), key);
            }
        }
    }

    @Override
    public void deleteRange(DeleteRangeRequest request, StreamObserver<DeleteRangeResponse> responseObserver) {
        if (!KetaEngine.getInstance().isLeader()) {
            responseObserver.onError((Throwable)KetaErrorType.LeaderChanged.toException());
            return;
        }
        LOG.info("Delete request: [{}, {})", (Object)request.getKey(), (Object)request.getRangeEnd());
        KetaTransactionManager txMgr = KetaEngine.getInstance().getTxManager();
        Transaction tx = null;
        try {
            tx = txMgr.begin();
            DeleteRangeResponse response = this.doDeleteRange(request);
            txMgr.commit(tx);
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
            LOG.info("Delete success: [{}, {})", (Object)request.getKey(), (Object)request.getRangeEnd());
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    txMgr.rollback(tx);
                }
                catch (TransactionException transactionException) {
                    // empty catch block
                }
            }
            responseObserver.onError((Throwable)GrpcUtils.toStatusException(e));
        }
    }

    private DeleteRangeResponse doDeleteRange(DeleteRangeRequest request) {
        KetaAuthManager authMgr = KetaEngine.getInstance().getAuthManager();
        authMgr.checkDeletePermitted((String)AuthServerInterceptor.USER_CTX_KEY.get(), request.getKey(), request.getRangeEnd());
        TxVersionedCache cache = KetaEngine.getInstance().getTxCache();
        byte[] from = request.getKey().toByteArray();
        if (from.length == 0) {
            throw new KetaException(KetaErrorType.EmptyKey);
        }
        byte[] to = request.getRangeEnd().toByteArray();
        ArrayList<Object> keys = new ArrayList<Object>();
        DeleteRangeResponse.Builder responseBuilder = DeleteRangeResponse.newBuilder();
        responseBuilder.setHeader(this.toResponseHeader());
        if (to.length == 0) {
            VersionedValue versioned = cache.get(from);
            if (versioned != null) {
                keys.add(from);
                if (request.getPrevKv()) {
                    authMgr.checkRangePermitted((String)AuthServerInterceptor.USER_CTX_KEY.get(), request.getKey(), request.getRangeEnd());
                    io.etcd.jetcd.api.KeyValue kv = ProtoUtils.toKeyValue((byte[])from, (VersionedValue)versioned);
                    responseBuilder.addPrevKvs(kv);
                }
                responseBuilder.setDeleted(1L);
            }
        } else {
            if (to.length == 1 && to[0] == 0) {
                to = null;
            }
            long count = 0L;
            try (KeyValueIterator iter = cache.range(from, true, to, false);){
                while (iter.hasNext()) {
                    KeyValue entry = (KeyValue)iter.next();
                    keys.add(entry.key);
                    if (request.getPrevKv()) {
                        authMgr.checkRangePermitted((String)AuthServerInterceptor.USER_CTX_KEY.get(), request.getKey(), request.getRangeEnd());
                        io.etcd.jetcd.api.KeyValue kv = ProtoUtils.toKeyValue((byte[])((byte[])entry.key), (VersionedValue)((VersionedValue)entry.value));
                        responseBuilder.addPrevKvs(kv);
                    }
                    ++count;
                }
            }
            responseBuilder.setDeleted(count);
        }
        cache.remove(keys);
        return responseBuilder.build();
    }

    @Override
    public void txn(TxnRequest request, StreamObserver<TxnResponse> responseObserver) {
        if (!KetaEngine.getInstance().isLeader()) {
            responseObserver.onError((Throwable)KetaErrorType.LeaderChanged.toException());
            return;
        }
        LOG.info("Txn request: {}", request.getCompareList());
        KetaTransactionManager txMgr = KetaEngine.getInstance().getTxManager();
        Transaction tx = null;
        try {
            tx = txMgr.begin();
            TxnResponse response = this.doTxn(request);
            txMgr.commit(tx);
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
            LOG.info("Txn success: {}", request.getCompareList());
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    txMgr.rollback(tx);
                }
                catch (TransactionException transactionException) {
                    // empty catch block
                }
            }
            responseObserver.onError((Throwable)GrpcUtils.toStatusException(e));
        }
    }

    private TxnResponse doTxn(TxnRequest request) {
        boolean succeeded = this.doCompares(request.getCompareList());
        List<ResponseOp> responses = this.doRequests(succeeded ? request.getSuccessList() : request.getFailureList());
        return TxnResponse.newBuilder().setHeader(this.toResponseHeader()).setSucceeded(succeeded).addAllResponses(responses).build();
    }

    private boolean doCompares(List<Compare> compares) {
        for (Compare compare : compares) {
            if (this.doCompare(compare)) continue;
            return false;
        }
        return true;
    }

    private boolean doCompare(Compare compare) {
        KetaAuthManager authMgr = KetaEngine.getInstance().getAuthManager();
        authMgr.checkRangePermitted((String)AuthServerInterceptor.USER_CTX_KEY.get(), compare.getKey(), compare.getRangeEnd());
        TxVersionedCache cache = KetaEngine.getInstance().getTxCache();
        byte[] from = compare.getKey().toByteArray();
        if (from.length == 0) {
            throw new KetaException(KetaErrorType.EmptyKey);
        }
        byte[] to = compare.getRangeEnd().toByteArray();
        if (to.length == 0) {
            VersionedValue versioned = cache.get(from);
            return this.doCompareOne(compare, versioned);
        }
        if (to.length == 1 && to[0] == 0) {
            to = null;
        }
        try (KeyValueIterator iter = cache.range(from, true, to, false);){
            while (iter.hasNext()) {
                KeyValue entry = (KeyValue)iter.next();
                if (this.doCompareOne(compare, (VersionedValue)entry.value)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private boolean doCompareOne(Compare compare, VersionedValue versioned) {
        switch (compare.getTarget()) {
            case VERSION: {
                return this.doCompareVersion(compare, versioned);
            }
            case CREATE: {
                return this.doCompareCreate(compare, versioned);
            }
            case MOD: {
                return this.doCompareRevision(compare, versioned);
            }
            case VALUE: {
                return this.doCompareValue(compare, versioned);
            }
        }
        throw new IllegalArgumentException("Unsupported target type " + (Object)((Object)compare.getTarget()));
    }

    private boolean doCompareVersion(Compare compare, VersionedValue versioned) {
        long cmpVersion = compare.getVersion();
        long version = versioned != null ? versioned.getSequence() : 0L;
        return this.doCompareLongs(compare, version, cmpVersion);
    }

    private boolean doCompareCreate(Compare compare, VersionedValue versioned) {
        long cmpCreate = compare.getCreateRevision();
        long create = versioned != null ? versioned.getCreate() : 0L;
        return this.doCompareLongs(compare, create, cmpCreate);
    }

    private boolean doCompareRevision(Compare compare, VersionedValue versioned) {
        long cmpMod = compare.getModRevision();
        long mod = versioned != null ? versioned.getCommit() : 0L;
        return this.doCompareLongs(compare, mod, cmpMod);
    }

    private boolean doCompareLongs(Compare compare, long value1, long value2) {
        int cmp = Long.compare(value1, value2);
        switch (compare.getResult()) {
            case EQUAL: {
                return cmp == 0;
            }
            case GREATER: {
                return cmp > 0;
            }
            case LESS: {
                return cmp < 0;
            }
            case NOT_EQUAL: {
                return cmp != 0;
            }
        }
        throw new IllegalArgumentException("Unsupported compare type " + (Object)((Object)compare.getResult()));
    }

    private boolean doCompareValue(Compare compare, VersionedValue versioned) {
        byte[] value = compare.getValue().toByteArray();
        Integer cmp = versioned != null ? Integer.valueOf(VersionedCache.BYTES_COMPARATOR.compare(versioned.getValue().toByteArray(), value)) : null;
        switch (compare.getResult()) {
            case EQUAL: {
                return cmp != null ? cmp == 0 : value == null || value.length == 0;
            }
            case GREATER: {
                return cmp != null && cmp > 0;
            }
            case LESS: {
                return cmp != null && cmp < 0;
            }
            case NOT_EQUAL: {
                return cmp != null ? cmp != 0 : value != null && value.length != 0;
            }
        }
        throw new IllegalArgumentException("Unsupported compare type " + (Object)((Object)compare.getResult()));
    }

    private List<ResponseOp> doRequests(List<RequestOp> requests) {
        ArrayList<ResponseOp> responses = new ArrayList<ResponseOp>();
        for (RequestOp request : requests) {
            responses.add(this.doRequest(request));
        }
        return responses;
    }

    private ResponseOp doRequest(RequestOp request) {
        ResponseOp.Builder responseBuilder = ResponseOp.newBuilder();
        switch (request.getRequestCase()) {
            case REQUEST_RANGE: {
                return responseBuilder.setResponseRange(this.doRange(request.getRequestRange())).build();
            }
            case REQUEST_PUT: {
                return responseBuilder.setResponsePut(this.doPut(request.getRequestPut())).build();
            }
            case REQUEST_DELETE_RANGE: {
                return responseBuilder.setResponseDeleteRange(this.doDeleteRange(request.getRequestDeleteRange())).build();
            }
            case REQUEST_TXN: {
                return responseBuilder.setResponseTxn(this.doTxn(request.getRequestTxn())).build();
            }
            case REQUEST_NOT_SET: {
                return responseBuilder.build();
            }
        }
        throw new IllegalArgumentException("Unsupported request type " + (Object)((Object)request.getRequestCase()));
    }

    @Override
    public void compact(CompactionRequest request, StreamObserver<CompactionResponse> responseObserver) {
        if (!KetaEngine.getInstance().isLeader()) {
            responseObserver.onError((Throwable)KetaErrorType.LeaderChanged.toException());
            return;
        }
        super.compact(request, responseObserver);
    }

    private ResponseHeader toResponseHeader() {
        KetaTransaction tx = KetaTransaction.currentTransaction();
        return GrpcUtils.toResponseHeader(this.elector.getMemberId(), tx.getStartTimestamp());
    }
}

