/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.internal.proxy;

import io.katharsis.client.internal.proxy.ClientProxyFactory;
import io.katharsis.client.internal.proxy.ClientProxyFactoryContext;
import io.katharsis.client.internal.proxy.CollectionInvocationHandler;
import io.katharsis.client.internal.proxy.ObjectProxy;
import io.katharsis.core.internal.utils.ClassUtils;
import io.katharsis.core.internal.utils.WrappedList;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.list.ResourceList;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class BasicProxyFactory
implements ClientProxyFactory {
    private ClientProxyFactoryContext context;
    private Constructor<?> listConstructor;
    private Constructor<?> setConstructor;

    @Override
    public void init(ClientProxyFactoryContext context) {
        this.context = context;
        ClassLoader loader = this.getClass().getClassLoader();
        this.listConstructor = Proxy.getProxyClass(loader, ObjectProxy.class, ResourceList.class).getConstructors()[0];
        this.setConstructor = Proxy.getProxyClass(loader, ObjectProxy.class, Set.class).getConstructors()[0];
    }

    @Override
    public <T> T createResourceProxy(Class<T> clazz, Object id) {
        Object instance = ClassUtils.newInstance(clazz);
        ResourceRegistry resourceRegistry = this.context.getModuleRegistry().getResourceRegistry();
        RegistryEntry entry = resourceRegistry.findEntry(clazz);
        ResourceInformation resourceInformation = entry.getResourceInformation();
        resourceInformation.setId(instance, id);
        return (T)instance;
    }

    @Override
    public <C extends Collection<T>, T> C createCollectionProxy(Class<T> resourceClass, Class<C> collectionClass, String url) {
        boolean useSet = Set.class.isAssignableFrom(collectionClass);
        CollectionInvocationHandler handler = new CollectionInvocationHandler(resourceClass, url, this.context, useSet);
        Constructor<?> constructor = useSet ? this.setConstructor : this.listConstructor;
        try {
            Collection lazyCollection = (Collection)constructor.newInstance(handler);
            boolean isCustomClass = WrappedList.class.isAssignableFrom(collectionClass);
            if (isCustomClass) {
                WrappedList collectionImpl = (WrappedList)collectionClass.newInstance();
                collectionImpl.setWrappedList((List)lazyCollection);
                return (C)collectionImpl;
            }
            return (C)lazyCollection;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

