/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.client.KatharsisClient;
import io.katharsis.client.RelationshipRepositoryStub;
import io.katharsis.client.internal.AbstractStub;
import io.katharsis.core.internal.utils.JsonApiUrlBuilder;
import io.katharsis.core.internal.utils.PropertyUtils;
import io.katharsis.legacy.queryParams.QueryParams;
import io.katharsis.queryspec.QuerySpec;
import io.katharsis.repository.RelationshipRepositoryV2;
import io.katharsis.repository.request.HttpMethod;
import io.katharsis.resource.Document;
import io.katharsis.resource.ResourceIdentifier;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.list.DefaultResourceList;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.utils.Nullable;
import java.io.Serializable;
import java.util.ArrayList;

public class RelationshipRepositoryStubImpl<T, I extends Serializable, D, J extends Serializable>
extends AbstractStub
implements RelationshipRepositoryStub<T, I, D, J>,
RelationshipRepositoryV2<T, I, D, J> {
    private Class<T> sourceClass;
    private Class<D> targetClass;
    private ResourceInformation sourceResourceInformation;
    private RegistryEntry relationshipEntry;

    public RelationshipRepositoryStubImpl(KatharsisClient client, Class<T> sourceClass, Class<D> targetClass, ResourceInformation sourceResourceInformation, JsonApiUrlBuilder urlBuilder, RegistryEntry relationshipEntry) {
        super(client, urlBuilder);
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.sourceResourceInformation = sourceResourceInformation;
        this.relationshipEntry = relationshipEntry;
    }

    public void setRelation(T source, J targetId, String fieldName) {
        Serializable sourceId = this.getSourceId(source);
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, (Object)sourceId, (QuerySpec)null, fieldName);
        this.executeWithId(url, HttpMethod.PATCH, targetId);
    }

    public void setRelations(T source, Iterable<J> targetIds, String fieldName) {
        Serializable sourceId = this.getSourceId(source);
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, (Object)sourceId, (QuerySpec)null, fieldName);
        this.executeWithIds(url, HttpMethod.PATCH, targetIds);
    }

    public void addRelations(T source, Iterable<J> targetIds, String fieldName) {
        Serializable sourceId = this.getSourceId(source);
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, (Object)sourceId, (QuerySpec)null, fieldName);
        this.executeWithIds(url, HttpMethod.POST, targetIds);
    }

    public void removeRelations(T source, Iterable<J> targetIds, String fieldName) {
        Serializable sourceId = this.getSourceId(source);
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, (Object)sourceId, (QuerySpec)null, fieldName);
        this.executeWithIds(url, HttpMethod.DELETE, targetIds);
    }

    private Serializable getSourceId(T source) {
        ResourceField idField = this.sourceResourceInformation.getIdField();
        return (Serializable)PropertyUtils.getProperty(source, (String)idField.getUnderlyingName());
    }

    public D findOneTarget(I sourceId, String fieldName, QueryParams queryParams) {
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, sourceId, queryParams, fieldName);
        return (D)this.executeGet(url, AbstractStub.ResponseType.RESOURCE);
    }

    @Override
    public DefaultResourceList<D> findManyTargets(I sourceId, String fieldName, QueryParams queryParams) {
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, sourceId, queryParams, fieldName);
        return (DefaultResourceList)this.executeGet(url, AbstractStub.ResponseType.RESOURCES);
    }

    public D findOneTarget(I sourceId, String fieldName, QuerySpec querySpec) {
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, sourceId, querySpec, fieldName);
        return (D)this.executeGet(url, AbstractStub.ResponseType.RESOURCE);
    }

    public DefaultResourceList<D> findManyTargets(I sourceId, String fieldName, QuerySpec querySpec) {
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, sourceId, querySpec, fieldName);
        return (DefaultResourceList)this.executeGet(url, AbstractStub.ResponseType.RESOURCES);
    }

    private void executeWithIds(String requestUrl, HttpMethod method, Iterable<?> targetIds) {
        Document document = new Document();
        ArrayList<ResourceIdentifier> resourceIdentifiers = new ArrayList<ResourceIdentifier>();
        for (Object targetId : targetIds) {
            String strTargetId = this.sourceResourceInformation.toIdString(targetId);
            resourceIdentifiers.add(new ResourceIdentifier(strTargetId, this.sourceResourceInformation.getResourceType()));
        }
        document.setData(Nullable.of(resourceIdentifiers));
        this.doExecute(requestUrl, method, document);
    }

    private void executeWithId(String requestUrl, HttpMethod method, Object targetIds) {
        Document document = new Document();
        String strTargetId = this.sourceResourceInformation.toIdString(targetIds);
        ResourceIdentifier resourceIdentifier = new ResourceIdentifier(strTargetId, this.sourceResourceInformation.getResourceType());
        document.setData(Nullable.of((Object)resourceIdentifier));
        this.doExecute(requestUrl, method, document);
    }

    private void doExecute(String requestUrl, HttpMethod method, Document document) {
        String requestBodyValue;
        ObjectMapper objectMapper = this.client.getObjectMapper();
        try {
            requestBodyValue = objectMapper.writeValueAsString((Object)document);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        this.execute(requestUrl, AbstractStub.ResponseType.NONE, method, requestBodyValue);
    }

    public Class<T> getSourceResourceClass() {
        return this.sourceClass;
    }

    public Class<D> getTargetResourceClass() {
        return this.targetClass;
    }
}

