/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.katharsis.client.ResponseBodyException;
import io.katharsis.client.internal.proxy.ClientProxyFactory;
import io.katharsis.core.internal.dispatcher.controller.ResourceUpsert;
import io.katharsis.core.internal.dispatcher.path.JsonPath;
import io.katharsis.core.internal.resource.DocumentMapper;
import io.katharsis.core.internal.utils.PropertyUtils;
import io.katharsis.errorhandling.exception.RepositoryNotFoundException;
import io.katharsis.legacy.internal.RepositoryMethodParameterProvider;
import io.katharsis.repository.request.QueryAdapter;
import io.katharsis.repository.response.Response;
import io.katharsis.resource.Document;
import io.katharsis.resource.Relationship;
import io.katharsis.resource.Resource;
import io.katharsis.resource.ResourceIdentifier;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.utils.parser.TypeParser;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ClientResourceUpsert
extends ResourceUpsert {
    private ClientProxyFactory proxyFactory;
    private Map<String, Object> resourceMap = new HashMap<String, Object>();

    public ClientResourceUpsert(ResourceRegistry resourceRegistry, TypeParser typeParser, ObjectMapper objectMapper, DocumentMapper documentMapper, ClientProxyFactory proxyFactory) {
        super(resourceRegistry, typeParser, objectMapper, documentMapper);
        this.proxyFactory = proxyFactory;
    }

    public String getUID(ResourceIdentifier id) {
        return id.getType() + "#" + id.getId();
    }

    public String getUID(RegistryEntry entry, Serializable id) {
        return entry.getResourceInformation().getResourceType() + "#" + id;
    }

    public void setRelations(List<Resource> resources) {
        for (Resource resource : resources) {
            String uid = this.getUID((ResourceIdentifier)resource);
            Object object = this.resourceMap.get(uid);
            RegistryEntry registryEntry = this.resourceRegistry.getEntry(resource.getType());
            QueryAdapter queryAdapter = null;
            RepositoryMethodParameterProvider parameterProvider = null;
            this.setRelations(object, registryEntry, resource, queryAdapter, parameterProvider);
        }
    }

    protected Object fetchRelatedObject(RegistryEntry entry, Serializable relationId, RepositoryMethodParameterProvider parameterProvider, QueryAdapter queryAdapter) {
        String uid = this.getUID(entry, relationId);
        Object relatedResource = this.resourceMap.get(uid);
        if (relatedResource != null) {
            return relatedResource;
        }
        ResourceInformation resourceInformation = entry.getResourceInformation();
        Class resourceClass = resourceInformation.getResourceClass();
        return this.proxyFactory.createResourceProxy(resourceClass, relationId);
    }

    public List<Object> allocateResources(List<Resource> resources) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Resource resource : resources) {
            RegistryEntry registryEntry = this.resourceRegistry.getEntry(resource.getType());
            if (registryEntry == null) {
                throw new RepositoryNotFoundException(resource.getType());
            }
            ResourceInformation resourceInformation = registryEntry.getResourceInformation();
            Object object = this.newResource(resourceInformation, resource);
            this.setId(resource, object, resourceInformation);
            this.setAttributes(resource, object, resourceInformation);
            this.setLinks(resource, object, resourceInformation);
            this.setMeta(resource, object, resourceInformation);
            objects.add(object);
            String uid = this.getUID((ResourceIdentifier)resource);
            this.resourceMap.put(uid, object);
        }
        return objects;
    }

    protected void setLinks(Resource dataBody, Object instance, ResourceInformation resourceInformation) {
        ResourceField linksField = resourceInformation.getLinksField();
        if (dataBody.getLinks() != null && linksField != null) {
            ObjectNode linksNode = dataBody.getLinks();
            Class linksClass = linksField.getType();
            ObjectReader linksMapper = this.objectMapper.readerFor(linksClass);
            try {
                Object links = linksMapper.readValue((JsonNode)linksNode);
                PropertyUtils.setProperty((Object)instance, (String)linksField.getUnderlyingName(), (Object)links);
            }
            catch (IOException e) {
                throw new ResponseBodyException("failed to parse links information", e);
            }
        }
    }

    protected void setMeta(Resource dataBody, Object instance, ResourceInformation resourceInformation) {
        ResourceField metaField = resourceInformation.getMetaField();
        if (dataBody.getMeta() != null && metaField != null) {
            ObjectNode metaNode = dataBody.getMeta();
            Class metaClass = metaField.getType();
            ObjectReader metaMapper = this.objectMapper.readerFor(metaClass);
            try {
                Object meta = metaMapper.readValue((JsonNode)metaNode);
                PropertyUtils.setProperty((Object)instance, (String)metaField.getUnderlyingName(), (Object)meta);
            }
            catch (IOException e) {
                throw new ResponseBodyException("failed to parse links information", e);
            }
        }
    }

    public boolean isAcceptable(JsonPath jsonPath, String requestType) {
        throw new UnsupportedOperationException();
    }

    public Response handle(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document document) {
        throw new UnsupportedOperationException();
    }

    protected void setRelationsField(Object newResource, RegistryEntry registryEntry, Map.Entry<String, Relationship> property, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider) {
        Relationship relationship = property.getValue();
        if (!relationship.getData().isPresent()) {
            ObjectNode links = relationship.getLinks();
            if (links != null) {
                String fieldName = property.getKey();
                ResourceInformation resourceInformation = registryEntry.getResourceInformation();
                ResourceField field = resourceInformation.findRelationshipFieldByName(fieldName);
                Class elementType = field.getElementType();
                Class collectionClass = field.getType();
                JsonNode relatedNode = links.get("related");
                if (relatedNode != null) {
                    String url = relatedNode.asText().trim();
                    Object proxy = this.proxyFactory.createCollectionProxy(elementType, collectionClass, url);
                    PropertyUtils.setProperty((Object)newResource, (String)fieldName, proxy);
                }
            }
        } else {
            super.setRelationsField(newResource, registryEntry, property, queryAdapter, parameterProvider);
        }
    }
}

