/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.http.okhttp;

import io.katharsis.client.http.HttpAdapterRequest;
import io.katharsis.client.http.HttpAdapterResponse;
import io.katharsis.client.http.okhttp.OkHttpResponse;
import io.katharsis.repository.request.HttpMethod;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpRequest
implements HttpAdapterRequest {
    private Request.Builder builder;
    private OkHttpClient client;

    public OkHttpRequest(OkHttpClient client, String url, HttpMethod method, String requestBody) {
        this.client = client;
        this.builder = new Request.Builder().url(url);
        RequestBody requestBodyObj = requestBody != null ? RequestBody.create(null, (String)requestBody) : null;
        this.builder.method(method.toString(), requestBodyObj);
    }

    @Override
    public void header(String name, String value) {
        this.builder = this.builder.header(name, value);
    }

    @Override
    public HttpAdapterResponse execute() throws IOException {
        Request request = this.builder.build();
        Response response = this.client.newCall(request).execute();
        return new OkHttpResponse(response);
    }
}

