/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.http.okhttp;

import io.katharsis.client.http.HttpAdapter;
import io.katharsis.client.http.HttpAdapterRequest;
import io.katharsis.client.http.okhttp.OkHttpAdapterListener;
import io.katharsis.client.http.okhttp.OkHttpRequest;
import io.katharsis.repository.request.HttpMethod;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class OkHttpAdapter
implements HttpAdapter {
    private OkHttpClient impl;
    private CopyOnWriteArrayList<OkHttpAdapterListener> listeners = new CopyOnWriteArrayList();
    private Long networkTimeout;

    public void addListener(OkHttpAdapterListener listener) {
        if (this.impl != null) {
            throw new IllegalStateException("already initialized");
        }
        this.listeners.add(listener);
    }

    public OkHttpClient getImplementation() {
        if (this.impl == null) {
            this.initImpl();
        }
        return this.impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initImpl() {
        OkHttpAdapter okHttpAdapter = this;
        synchronized (okHttpAdapter) {
            if (this.impl == null) {
                OkHttpClient.Builder builder = new OkHttpClient.Builder();
                if (this.networkTimeout != null) {
                    builder.readTimeout(this.networkTimeout.longValue(), TimeUnit.MILLISECONDS);
                }
                for (OkHttpAdapterListener listener : this.listeners) {
                    listener.onBuild(builder);
                }
                this.impl = builder.build();
            }
        }
    }

    @Override
    public HttpAdapterRequest newRequest(String url, HttpMethod method, String requestBody) {
        OkHttpClient impl = this.getImplementation();
        return new OkHttpRequest(impl, url, method, requestBody);
    }

    public static HttpAdapter newInstance() {
        return new OkHttpAdapter();
    }

    @Override
    public void setReceiveTimeout(int timeout, TimeUnit unit) {
        this.networkTimeout = unit.toMillis(timeout);
    }
}

