/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.client.KatharsisClient;
import io.katharsis.client.ResourceRepositoryStub;
import io.katharsis.client.internal.AbstractStub;
import io.katharsis.client.internal.ClientDocumentMapper;
import io.katharsis.core.internal.utils.JsonApiUrlBuilder;
import io.katharsis.core.internal.utils.PropertyUtils;
import io.katharsis.legacy.queryParams.QueryParams;
import io.katharsis.queryspec.QuerySpec;
import io.katharsis.repository.ResourceRepositoryV2;
import io.katharsis.repository.request.HttpMethod;
import io.katharsis.repository.response.JsonApiResponse;
import io.katharsis.resource.Document;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.list.DefaultResourceList;
import java.io.Serializable;
import java.util.List;

public class ResourceRepositoryStubImpl<T, I extends Serializable>
extends AbstractStub
implements ResourceRepositoryV2<T, I>,
ResourceRepositoryStub<T, I> {
    private ResourceInformation resourceInformation;
    private Class<T> resourceClass;

    public ResourceRepositoryStubImpl(KatharsisClient client, Class<T> resourceClass, ResourceInformation resourceInformation, JsonApiUrlBuilder urlBuilder) {
        super(client, urlBuilder);
        this.resourceClass = resourceClass;
        this.resourceInformation = resourceInformation;
    }

    private Object executeUpdate(String requestUrl, T resource, boolean create) {
        String requestBodyValue;
        JsonApiResponse response = new JsonApiResponse();
        response.setEntity(resource);
        ClientDocumentMapper documentMapper = this.client.getDocumentMapper();
        Document requestDocument = documentMapper.toDocument(response, null);
        ObjectMapper objectMapper = this.client.getObjectMapper();
        try {
            requestBodyValue = objectMapper.writeValueAsString((Object)requestDocument);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        HttpMethod method = create || this.client.getPushAlways() ? HttpMethod.POST : HttpMethod.PATCH;
        return this.execute(requestUrl, AbstractStub.ResponseType.RESOURCE, method, requestBodyValue);
    }

    public T findOne(I id, QueryParams queryParams) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, id, queryParams);
        return this.findOne(url);
    }

    @Override
    public List<T> findAll(QueryParams queryParams) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, null, queryParams);
        return this.findAll(url);
    }

    @Override
    public List<T> findAll(Iterable<I> ids, QueryParams queryParams) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, ids, queryParams);
        return this.findAll(url);
    }

    public <S extends T> S save(S entity) {
        return this.modify(entity, false);
    }

    private <S extends T> S modify(S entity, boolean create) {
        Object id = this.getId(entity, create);
        String url = this.urlBuilder.buildUrl(this.resourceInformation, id, (QuerySpec)null);
        return (S)this.executeUpdate(url, entity, create);
    }

    @Override
    public <S extends T> S create(S entity) {
        return this.modify(entity, true);
    }

    private <S extends T> Object getId(S entity, boolean create) {
        if (this.client.getPushAlways()) {
            return null;
        }
        if (create) {
            return null;
        }
        ResourceField idField = this.resourceInformation.getIdField();
        return PropertyUtils.getProperty(entity, (String)idField.getUnderlyingName());
    }

    public void delete(I id) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, id, (QuerySpec)null);
        this.executeDelete(url);
    }

    public Class<T> getResourceClass() {
        return this.resourceClass;
    }

    public T findOne(I id, QuerySpec querySpec) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, id, querySpec);
        return this.findOne(url);
    }

    public DefaultResourceList<T> findAll(QuerySpec querySpec) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, null, querySpec);
        return this.findAll(url);
    }

    public DefaultResourceList<T> findAll(Iterable<I> ids, QuerySpec queryPaquerySpecrams) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, ids, queryPaquerySpecrams);
        return this.findAll(url);
    }

    public DefaultResourceList<T> findAll(String url) {
        return (DefaultResourceList)this.executeGet(url, AbstractStub.ResponseType.RESOURCES);
    }

    private T findOne(String url) {
        return (T)this.executeGet(url, AbstractStub.ResponseType.RESOURCE);
    }
}

