/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.http.apache;

import io.katharsis.client.http.HttpAdapter;
import io.katharsis.client.http.HttpAdapterRequest;
import io.katharsis.client.http.apache.HttpClientAdapterListener;
import io.katharsis.client.http.apache.HttpClientRequest;
import io.katharsis.repository.request.HttpMethod;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class HttpClientAdapter
implements HttpAdapter {
    private CloseableHttpClient impl;
    private CopyOnWriteArrayList<HttpClientAdapterListener> listeners = new CopyOnWriteArrayList();
    private Integer receiveTimeout;

    public void addListener(HttpClientAdapterListener listener) {
        if (this.impl != null) {
            throw new IllegalStateException("already initialized");
        }
        this.listeners.add(listener);
    }

    public CloseableHttpClient getImplementation() {
        if (this.impl == null) {
            this.initImpl();
        }
        return this.impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initImpl() {
        HttpClientAdapter httpClientAdapter = this;
        synchronized (httpClientAdapter) {
            if (this.impl == null) {
                HttpClientBuilder builder = HttpClients.custom();
                if (this.receiveTimeout != null) {
                    RequestConfig.Builder requestBuilder = RequestConfig.custom();
                    requestBuilder = requestBuilder.setSocketTimeout(this.receiveTimeout.intValue());
                    builder.setDefaultRequestConfig(requestBuilder.build());
                }
                for (HttpClientAdapterListener listener : this.listeners) {
                    listener.onBuild(builder);
                }
                this.impl = builder.build();
            }
        }
    }

    @Override
    public HttpAdapterRequest newRequest(String url, HttpMethod method, String requestBody) {
        CloseableHttpClient impl = this.getImplementation();
        return new HttpClientRequest(impl, url, method, requestBody);
    }

    public static HttpClientAdapter newInstance() {
        return new HttpClientAdapter();
    }

    @Override
    public void setReceiveTimeout(int timeout, TimeUnit unit) {
        this.receiveTimeout = (int)unit.toMillis(timeout);
    }
}

