/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.internal.proxy;

import io.katharsis.client.internal.proxy.ClientProxyFactoryContext;
import io.katharsis.client.internal.proxy.ObjectProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;

public class CollectionInvocationHandler
implements InvocationHandler,
ObjectProxy {
    private Collection<?> collection;
    private String url;
    private Class<?> resourceClass;
    private ClientProxyFactoryContext context;
    private boolean useSet;

    public CollectionInvocationHandler(Class<?> resourceClass, String url, ClientProxyFactoryContext context, boolean useSet) {
        this.url = url;
        this.resourceClass = resourceClass;
        this.context = context;
        this.useSet = useSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class || method.getDeclaringClass() == ObjectProxy.class) {
            return method.invoke((Object)this, args);
        }
        if (this.collection == null) {
            CollectionInvocationHandler collectionInvocationHandler = this;
            synchronized (collectionInvocationHandler) {
                if (this.collection == null) {
                    this.collection = this.context.getCollection(this.resourceClass, this.url);
                    if (this.useSet) {
                        this.collection = new HashSet(this.collection);
                    }
                }
            }
        }
        try {
            return method.invoke(this.collection, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public boolean isLoaded() {
        return this.collection != null;
    }
}

