/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.client.ClientException;
import io.katharsis.client.KatharsisClient;
import io.katharsis.client.http.HttpAdapter;
import io.katharsis.client.http.HttpAdapterRequest;
import io.katharsis.client.http.HttpAdapterResponse;
import io.katharsis.client.internal.ClientDocumentMapper;
import io.katharsis.core.internal.exception.ExceptionMapperRegistry;
import io.katharsis.core.internal.utils.JsonApiUrlBuilder;
import io.katharsis.errorhandling.ErrorResponse;
import io.katharsis.errorhandling.mapper.ExceptionMapper;
import io.katharsis.repository.request.HttpMethod;
import io.katharsis.resource.Document;
import io.katharsis.utils.Optional;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractStub {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStub.class);
    public static final String CONTENT_TYPE = "application/vnd.api+json";
    protected KatharsisClient client;
    protected JsonApiUrlBuilder urlBuilder;

    public AbstractStub(KatharsisClient client, JsonApiUrlBuilder urlBuilder) {
        this.client = client;
        this.urlBuilder = urlBuilder;
    }

    protected Object executeGet(String requestUrl, ResponseType responseType) {
        return this.execute(requestUrl, responseType, HttpMethod.GET, null);
    }

    protected Object executeDelete(String requestUrl) {
        return this.execute(requestUrl, ResponseType.NONE, HttpMethod.DELETE, null);
    }

    protected Object execute(String url, ResponseType responseType, HttpMethod method, String requestBody) {
        try {
            HttpAdapter httpAdapter = this.client.getHttpAdapter();
            HttpAdapterRequest request = httpAdapter.newRequest(url, method, requestBody);
            LOGGER.debug("requesting {} {}", (Object)method, (Object)url);
            if (requestBody != null) {
                LOGGER.debug("request body: {}", (Object)requestBody);
            }
            request.header("Content-Type", CONTENT_TYPE);
            request.header("Accept", CONTENT_TYPE);
            HttpAdapterResponse response = request.execute();
            if (!response.isSuccessful()) {
                throw this.handleError(response);
            }
            String body = response.body();
            LOGGER.debug("response body: {}", (Object)body);
            ObjectMapper objectMapper = this.client.getObjectMapper();
            if (responseType != ResponseType.NONE) {
                Document document = (Document)objectMapper.readValue(body, Document.class);
                ClientDocumentMapper documentMapper = this.client.getDocumentMapper();
                return documentMapper.fromDocument(document, responseType == ResponseType.RESOURCES);
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private RuntimeException handleError(HttpAdapterResponse response) throws IOException {
        ExceptionMapperRegistry exceptionMapperRegistry;
        Optional mapper;
        ObjectMapper objectMapper;
        Document document;
        ErrorResponse errorResponse = null;
        String body = response.body();
        if (body.length() > 0 && (document = (Document)(objectMapper = this.client.getObjectMapper()).readValue(body, Document.class)).getErrors() != null && !document.getErrors().isEmpty()) {
            errorResponse = new ErrorResponse((Iterable)document.getErrors(), response.code());
        }
        if (errorResponse == null) {
            errorResponse = new ErrorResponse(null, response.code());
        }
        if ((mapper = (exceptionMapperRegistry = this.client.getExceptionMapperRegistry()).findMapperFor(errorResponse)).isPresent()) {
            Throwable throwable = ((ExceptionMapper)mapper.get()).fromErrorResponse(errorResponse);
            if (throwable instanceof RuntimeException) {
                return (RuntimeException)throwable;
            }
            return new ClientException(response.code(), response.message(), throwable);
        }
        return new ClientException(response.code(), response.message());
    }

    public static enum ResponseType {
        NONE,
        RESOURCE,
        RESOURCES;

    }
}

