/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.http.apache;

import io.katharsis.client.http.HttpAdapterResponse;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class HttpClientResponse
implements HttpAdapterResponse {
    private CloseableHttpResponse response;
    private String body;

    public HttpClientResponse(CloseableHttpResponse response) throws ParseException, IOException {
        this.response = response;
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            this.body = EntityUtils.toString((HttpEntity)entity);
        }
    }

    @Override
    public boolean isSuccessful() {
        return this.response.getStatusLine().getStatusCode() < 400;
    }

    @Override
    public String body() throws IOException {
        return this.body;
    }

    @Override
    public int code() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public String message() {
        return this.response.getStatusLine().getReasonPhrase();
    }
}

