/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.katharsis.client.RelationshipRepositoryStub;
import io.katharsis.client.ResourceRepositoryStub;
import io.katharsis.client.action.ActionStubFactory;
import io.katharsis.client.action.ActionStubFactoryContext;
import io.katharsis.client.http.HttpAdapter;
import io.katharsis.client.http.apache.HttpClientAdapter;
import io.katharsis.client.http.okhttp.OkHttpAdapter;
import io.katharsis.client.internal.ClientDocumentMapper;
import io.katharsis.client.internal.ClientStubInvocationHandler;
import io.katharsis.client.internal.RelationshipRepositoryStubImpl;
import io.katharsis.client.internal.ResourceRepositoryStubImpl;
import io.katharsis.client.internal.proxy.BasicProxyFactory;
import io.katharsis.client.internal.proxy.ClientProxyFactory;
import io.katharsis.client.internal.proxy.ClientProxyFactoryContext;
import io.katharsis.client.module.ClientModule;
import io.katharsis.client.module.HttpAdapterAware;
import io.katharsis.core.internal.exception.ExceptionMapperLookup;
import io.katharsis.core.internal.exception.ExceptionMapperRegistry;
import io.katharsis.core.internal.exception.ExceptionMapperRegistryBuilder;
import io.katharsis.core.internal.jackson.JsonApiModuleBuilder;
import io.katharsis.core.internal.registry.DirectResponseRelationshipEntry;
import io.katharsis.core.internal.registry.DirectResponseResourceEntry;
import io.katharsis.core.internal.registry.ResourceRegistryImpl;
import io.katharsis.core.internal.repository.adapter.RelationshipRepositoryAdapter;
import io.katharsis.core.internal.repository.adapter.ResourceRepositoryAdapter;
import io.katharsis.core.internal.repository.information.ResourceRepositoryInformationImpl;
import io.katharsis.core.internal.utils.JsonApiUrlBuilder;
import io.katharsis.core.internal.utils.PreconditionUtil;
import io.katharsis.errorhandling.exception.RepositoryNotFoundException;
import io.katharsis.legacy.registry.DefaultResourceInformationBuilderContext;
import io.katharsis.legacy.registry.RepositoryInstanceBuilder;
import io.katharsis.legacy.repository.RelationshipRepository;
import io.katharsis.module.Module;
import io.katharsis.module.ModuleRegistry;
import io.katharsis.repository.RelationshipRepositoryV2;
import io.katharsis.repository.ResourceRepositoryV2;
import io.katharsis.repository.information.RepositoryInformationBuilder;
import io.katharsis.repository.information.RepositoryInformationBuilderContext;
import io.katharsis.repository.information.ResourceRepositoryInformation;
import io.katharsis.resource.information.ResourceField;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.information.ResourceInformationBuilder;
import io.katharsis.resource.list.DefaultResourceList;
import io.katharsis.resource.registry.ConstantServiceUrlProvider;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceEntry;
import io.katharsis.resource.registry.ResourceLookup;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.resource.registry.ResponseRelationshipEntry;
import io.katharsis.resource.registry.ServiceUrlProvider;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public class KatharsisClient {
    private static final String APACHE_HTTP_CLIENT_DETECTION_CLASS = "org.apache.http.impl.client.CloseableHttpClient";
    private static final String OK_HTTP_CLIENT_DETECTION_CLASS = "okhttp3.OkHttpClient";
    private HttpAdapter httpAdapter = this.detectHttpAdapter();
    private ObjectMapper objectMapper;
    private ResourceRegistry resourceRegistry;
    private ModuleRegistry moduleRegistry = new ModuleRegistry(false);
    private JsonApiUrlBuilder urlBuilder;
    private boolean initialized = false;
    private ExceptionMapperRegistry exceptionMapperRegistry;
    private boolean pushAlways = false;
    private ActionStubFactory actionStubFactory;
    private ClientDocumentMapper documentMapper;

    public KatharsisClient(String serviceUrl) {
        this((ServiceUrlProvider)new ConstantServiceUrlProvider(KatharsisClient.normalize(serviceUrl)));
    }

    public KatharsisClient(ServiceUrlProvider serviceUrlProvider) {
        this.moduleRegistry.addModule((Module)new ClientModule());
        this.resourceRegistry = new ClientResourceRegistry(this.moduleRegistry, serviceUrlProvider);
        this.urlBuilder = new JsonApiUrlBuilder(this.resourceRegistry);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        JsonApiModuleBuilder moduleBuilder = new JsonApiModuleBuilder();
        SimpleModule jsonApiModule = moduleBuilder.build(this.resourceRegistry, true);
        this.objectMapper.registerModule((com.fasterxml.jackson.databind.Module)jsonApiModule);
        this.documentMapper = new ClientDocumentMapper(this.resourceRegistry, this.objectMapper, null);
        this.setProxyFactory(new BasicProxyFactory());
    }

    public void setProxyFactory(ClientProxyFactory proxyFactory) {
        proxyFactory.init(new ClientProxyFactoryContext(){

            @Override
            public ModuleRegistry getModuleRegistry() {
                return KatharsisClient.this.moduleRegistry;
            }

            @Override
            public <T> DefaultResourceList<T> getCollection(Class<T> resourceClass, String url) {
                RegistryEntry entry = KatharsisClient.this.resourceRegistry.findEntry(resourceClass);
                ResourceInformation resourceInformation = entry.getResourceInformation();
                ResourceRepositoryStubImpl repositoryStub = new ResourceRepositoryStubImpl(KatharsisClient.this, resourceClass, resourceInformation, KatharsisClient.this.urlBuilder);
                return repositoryStub.findAll(url);
            }
        });
        this.documentMapper.setProxyFactory(proxyFactory);
    }

    private HttpAdapter detectHttpAdapter() {
        if (KatharsisClient.existsClass(OK_HTTP_CLIENT_DETECTION_CLASS)) {
            return OkHttpAdapter.newInstance();
        }
        if (KatharsisClient.existsClass(APACHE_HTTP_CLIENT_DETECTION_CLASS)) {
            return HttpClientAdapter.newInstance();
        }
        throw new IllegalStateException("no httpAdapter can be initialized, add okhttp3 (com.squareup.okhttp3:okhttp) or apache http client (org.apache.httpcomponents:httpclient) to the classpath");
    }

    private static boolean existsClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void setPushAlways(boolean pushAlways) {
        this.pushAlways = pushAlways;
    }

    public boolean getPushAlways() {
        return this.pushAlways;
    }

    private static String normalize(String serviceUrl) {
        if (serviceUrl.endsWith("/")) {
            return serviceUrl.substring(0, serviceUrl.length() - 1);
        }
        return serviceUrl;
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initModuleRegistry();
        this.initExceptionMapperRegistry();
        this.initResources();
    }

    private void initResources() {
        ResourceLookup resourceLookup = this.moduleRegistry.getResourceLookup();
        for (Class resourceClass : resourceLookup.getResourceClasses()) {
            this.getQuerySpecRepository(resourceClass);
        }
    }

    private void initModuleRegistry() {
        this.moduleRegistry.init(this.objectMapper);
    }

    private void initExceptionMapperRegistry() {
        ExceptionMapperLookup exceptionMapperLookup = this.moduleRegistry.getExceptionMapperLookup();
        this.exceptionMapperRegistry = new ExceptionMapperRegistryBuilder().build(exceptionMapperLookup);
    }

    private <T, I extends Serializable> RegistryEntry allocateRepository(Class<T> resourceClass, boolean allocateRelated) {
        ResourceInformationBuilder resourceInformationBuilder = this.moduleRegistry.getResourceInformationBuilder();
        DefaultResourceInformationBuilderContext context = new DefaultResourceInformationBuilderContext(resourceInformationBuilder);
        ResourceInformation resourceInformation = resourceInformationBuilder.build(resourceClass);
        final ResourceRepositoryStubImpl repositoryStub = new ResourceRepositoryStubImpl(this, resourceClass, resourceInformation, this.urlBuilder);
        RepositoryInstanceBuilder repositoryInstanceBuilder = new RepositoryInstanceBuilder(null, null){

            public Object buildRepository() {
                return repositoryStub;
            }
        };
        ResourceRepositoryInformationImpl repositoryInformation = new ResourceRepositoryInformationImpl(repositoryStub.getClass(), resourceInformation.getResourceType(), resourceInformation);
        DirectResponseResourceEntry resourceEntry = new DirectResponseResourceEntry(repositoryInstanceBuilder);
        ArrayList<ResponseRelationshipEntry> relationshipEntries = new ArrayList<ResponseRelationshipEntry>();
        RegistryEntry registryEntry = new RegistryEntry((ResourceRepositoryInformation)repositoryInformation, (ResourceEntry)resourceEntry, relationshipEntries);
        this.resourceRegistry.addEntry(resourceClass, registryEntry);
        this.allocateRepositoryRelations(registryEntry, allocateRelated, relationshipEntries);
        return registryEntry;
    }

    private <T> void allocateRepositoryRelations(RegistryEntry registryEntry, boolean allocateRelated, List<ResponseRelationshipEntry> relationshipEntries) {
        ResourceInformation resourceInformation = registryEntry.getResourceInformation();
        List relationshipFields = resourceInformation.getRelationshipFields();
        for (ResourceField relationshipField : relationshipFields) {
            ClientResourceRegistry clientResourceRegistry;
            final Class targetClass = relationshipField.getElementType();
            Class resourceClass = resourceInformation.getResourceClass();
            final RelationshipRepositoryStubImpl relationshipRepositoryStub = new RelationshipRepositoryStubImpl(this, resourceClass, targetClass, resourceInformation, this.urlBuilder, registryEntry);
            RepositoryInstanceBuilder<RelationshipRepository> relationshipRepositoryInstanceBuilder = new RepositoryInstanceBuilder<RelationshipRepository>(null, null){

                public RelationshipRepository buildRepository() {
                    return relationshipRepositoryStub;
                }
            };
            DirectResponseRelationshipEntry relationshipEntry = new DirectResponseRelationshipEntry((RepositoryInstanceBuilder)relationshipRepositoryInstanceBuilder){

                public Class<?> getTargetAffiliation() {
                    return targetClass;
                }
            };
            relationshipEntries.add((ResponseRelationshipEntry)relationshipEntry);
            if (!allocateRelated || (clientResourceRegistry = (ClientResourceRegistry)this.resourceRegistry).isInitialized(targetClass)) continue;
            this.allocateRepository(targetClass, true);
        }
    }

    @Deprecated
    public <R extends ResourceRepositoryV2<?, ?>> R getResourceRepository(Class<R> repositoryInterfaceClass) {
        return this.getRepositoryForInterface(repositoryInterfaceClass);
    }

    public <R extends ResourceRepositoryV2<?, ?>> R getRepositoryForInterface(Class<R> repositoryInterfaceClass) {
        RepositoryInformationBuilder informationBuilder = this.moduleRegistry.getRepositoryInformationBuilder();
        PreconditionUtil.assertTrue((String)"no a valid repository interface", (boolean)informationBuilder.accept(repositoryInterfaceClass));
        ResourceRepositoryInformation repositoryInformation = (ResourceRepositoryInformation)informationBuilder.build(repositoryInterfaceClass, this.newRepositoryInformationBuilderContext());
        Class resourceClass = repositoryInformation.getResourceInformation().getResourceClass();
        Object actionStub = this.actionStubFactory != null ? this.actionStubFactory.createStub(repositoryInterfaceClass) : null;
        ResourceRepositoryV2 repositoryStub = this.getQuerySpecRepository(resourceClass);
        ClassLoader classLoader = repositoryInterfaceClass.getClassLoader();
        ClientStubInvocationHandler invocationHandler = new ClientStubInvocationHandler(repositoryInterfaceClass, repositoryStub, actionStub);
        return (R)((ResourceRepositoryV2)Proxy.newProxyInstance(classLoader, new Class[]{repositoryInterfaceClass, ResourceRepositoryV2.class}, (InvocationHandler)invocationHandler));
    }

    private RepositoryInformationBuilderContext newRepositoryInformationBuilderContext() {
        return new RepositoryInformationBuilderContext(){

            public ResourceInformationBuilder getResourceInformationBuilder() {
                return KatharsisClient.this.moduleRegistry.getResourceInformationBuilder();
            }
        };
    }

    @Deprecated
    public <R extends RelationshipRepositoryV2<?, ?, ?, ?>> R getQueryParamsRelationshipRepository(Class<R> repositoryInterfaceClass) {
        return null;
    }

    @Deprecated
    public <T, I extends Serializable> ResourceRepositoryStub<T, I> getQueryParamsRepository(Class<T> resourceClass) {
        this.init();
        RegistryEntry entry = this.resourceRegistry.findEntry(resourceClass);
        ResourceRepositoryAdapter repositoryAdapter = entry.getResourceRepository(null);
        return (ResourceRepositoryStub)repositoryAdapter.getResourceRepository();
    }

    public <T, I extends Serializable> ResourceRepositoryV2<T, I> getRepositoryForType(Class<T> resourceClass) {
        this.init();
        RegistryEntry entry = this.resourceRegistry.findEntry(resourceClass);
        ResourceRepositoryAdapter repositoryAdapter = entry.getResourceRepository(null);
        return (ResourceRepositoryV2)repositoryAdapter.getResourceRepository();
    }

    @Deprecated
    public <T, I extends Serializable> ResourceRepositoryV2<T, I> getQuerySpecRepository(Class<T> resourceClass) {
        return this.getRepositoryForType(resourceClass);
    }

    public <T, I extends Serializable, D, J extends Serializable> RelationshipRepositoryStub<T, I, D, J> getQueryParamsRepository(Class<T> sourceClass, Class<D> targetClass) {
        this.init();
        RegistryEntry entry = this.resourceRegistry.findEntry(sourceClass);
        RelationshipRepositoryAdapter repositoryAdapter = entry.getRelationshipRepositoryForClass(targetClass, null);
        return (RelationshipRepositoryStub)repositoryAdapter.getRelationshipRepository();
    }

    public <T, I extends Serializable, D, J extends Serializable> RelationshipRepositoryV2<T, I, D, J> getRepositoryForType(Class<T> sourceClass, Class<D> targetClass) {
        this.init();
        RegistryEntry entry = this.resourceRegistry.findEntry(sourceClass);
        RelationshipRepositoryAdapter repositoryAdapter = entry.getRelationshipRepositoryForClass(targetClass, null);
        return (RelationshipRepositoryV2)repositoryAdapter.getRelationshipRepository();
    }

    @Deprecated
    public <T, I extends Serializable, D, J extends Serializable> RelationshipRepositoryV2<T, I, D, J> getQuerySpecRepository(Class<T> sourceClass, Class<D> targetClass) {
        return this.getRepositoryForType(sourceClass, targetClass);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setHttpAdapter(HttpAdapter httpAdapter) {
        this.httpAdapter = httpAdapter;
        List modules = this.moduleRegistry.getModules();
        for (Module module : modules) {
            if (!(module instanceof HttpAdapterAware)) continue;
            ((HttpAdapterAware)module).setHttpAdapter(this.getHttpAdapter());
        }
    }

    public ResourceRegistry getRegistry() {
        return this.resourceRegistry;
    }

    public void addModule(Module module) {
        if (module instanceof HttpAdapterAware) {
            ((HttpAdapterAware)module).setHttpAdapter(this.getHttpAdapter());
        }
        this.moduleRegistry.addModule(module);
    }

    public HttpAdapter getHttpAdapter() {
        return this.httpAdapter;
    }

    public ExceptionMapperRegistry getExceptionMapperRegistry() {
        return this.exceptionMapperRegistry;
    }

    public ActionStubFactory getActionStubFactory() {
        return this.actionStubFactory;
    }

    public void setActionStubFactory(ActionStubFactory actionStubFactory) {
        this.actionStubFactory = actionStubFactory;
        if (actionStubFactory != null) {
            actionStubFactory.init(new ActionStubFactoryContext(){

                @Override
                public ServiceUrlProvider getServiceUrlProvider() {
                    return KatharsisClient.this.moduleRegistry.getResourceRegistry().getServiceUrlProvider();
                }

                @Override
                public HttpAdapter getHttpAdapter() {
                    return KatharsisClient.this.httpAdapter;
                }
            });
        }
    }

    public ModuleRegistry getModuleRegistry() {
        return this.moduleRegistry;
    }

    public ClientDocumentMapper getDocumentMapper() {
        return this.documentMapper;
    }

    class ClientResourceRegistry
    extends ResourceRegistryImpl {
        public ClientResourceRegistry(ModuleRegistry moduleRegistry, ServiceUrlProvider serviceUrlProvider) {
            super(moduleRegistry, serviceUrlProvider);
        }

        protected synchronized RegistryEntry getEntry(Class<?> clazz, boolean allowNull) {
            RegistryEntry entry = (RegistryEntry)this.resources.get(clazz);
            if (entry == null) {
                ResourceInformationBuilder informationBuilder = KatharsisClient.this.moduleRegistry.getResourceInformationBuilder();
                if (!informationBuilder.accept(clazz)) {
                    throw new RepositoryNotFoundException(clazz.getName() + " not recognized as resource class, consider adding @JsonApiResource annotation");
                }
                entry = KatharsisClient.this.allocateRepository(clazz, true);
            }
            return entry;
        }

        public boolean isInitialized(Class<?> clazz) {
            return super.getEntry(clazz, true) != null;
        }
    }
}

