/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.client.KatharsisClient;
import io.katharsis.client.QuerySpecResourceRepositoryStub;
import io.katharsis.client.ResourceRepositoryStub;
import io.katharsis.client.internal.AbstractStub;
import io.katharsis.client.response.ResourceList;
import io.katharsis.queryParams.QueryParams;
import io.katharsis.queryspec.QuerySpec;
import io.katharsis.queryspec.internal.QueryAdapter;
import io.katharsis.queryspec.internal.QueryParamsAdapter;
import io.katharsis.queryspec.internal.QuerySpecAdapter;
import io.katharsis.request.path.JsonPath;
import io.katharsis.request.path.ResourcePath;
import io.katharsis.resource.field.ResourceField;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.response.BaseResponseContext;
import io.katharsis.response.CollectionResponseContext;
import io.katharsis.response.JsonApiResponse;
import io.katharsis.response.ResourceResponseContext;
import io.katharsis.utils.JsonApiUrlBuilder;
import io.katharsis.utils.PropertyUtils;
import java.io.Serializable;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;

public class ResourceRepositoryStubImpl<T, I extends Serializable>
extends AbstractStub
implements ResourceRepositoryStub<T, I>,
QuerySpecResourceRepositoryStub<T, I> {
    private ResourceInformation resourceInformation;
    private Class<T> resourceClass;

    public ResourceRepositoryStubImpl(KatharsisClient client, Class<T> resourceClass, ResourceInformation resourceInformation, JsonApiUrlBuilder urlBuilder) {
        super(client, urlBuilder);
        this.resourceClass = resourceClass;
        this.resourceInformation = resourceInformation;
    }

    private BaseResponseContext executeUpdate(HttpUrl requestUrl, T resource, QueryAdapter queryAdapter, boolean create) {
        String requestBodyValue;
        JsonApiResponse response = new JsonApiResponse();
        response.setEntity(resource);
        ResourcePath jsonPath = new ResourcePath(this.resourceInformation.getResourceType());
        ResourceResponseContext context = new ResourceResponseContext(response, (JsonPath)jsonPath, queryAdapter);
        ObjectMapper objectMapper = this.katharsis.getObjectMapper();
        try {
            requestBodyValue = objectMapper.writeValueAsString((Object)context);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        Request.Builder builder = new Request.Builder().url(requestUrl);
        builder = create || this.katharsis.getPushAlways() ? builder.post(RequestBody.create(null, (String)requestBodyValue)) : builder.patch(RequestBody.create(null, (String)requestBodyValue));
        return this.execute(builder, true);
    }

    public T findOne(I id, QueryParams queryParams) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, id, queryParams));
        return this.findOne(url);
    }

    @Override
    public List<T> findAll(QueryParams queryParams) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, null, queryParams));
        return this.findAll(url);
    }

    @Override
    public List<T> findAll(Iterable<I> ids, QueryParams queryParams) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, ids, queryParams));
        return this.findAll(url);
    }

    @Override
    public <S extends T> S save(S entity) {
        return this.save(entity, new QuerySpec(this.resourceClass));
    }

    @Override
    public <S extends T> S save(S entity, QueryParams queryParams) {
        return this.modify(entity, queryParams, false);
    }

    private <S extends T> S modify(S entity, QueryParams queryParams, boolean create) {
        String strId = this.getStringId(entity, create);
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, (Object)strId, (QuerySpec)null));
        BaseResponseContext context = this.executeUpdate(url, entity, (QueryAdapter)new QueryParamsAdapter(queryParams), create);
        return (S)context.getResponse().getEntity();
    }

    @Override
    public <S extends T> S save(S entity, QuerySpec querySpec) {
        return this.modify(entity, querySpec, false);
    }

    @Override
    public <S extends T> S create(S entity) {
        return this.modify(entity, new QuerySpec(this.resourceClass), true);
    }

    @Override
    public <S extends T> S create(S entity, QuerySpec querySpec) {
        return this.modify(entity, querySpec, true);
    }

    @Override
    public <S extends T> S create(S entity, QueryParams queryParams) {
        return this.modify(entity, queryParams, true);
    }

    private <S extends T> S modify(S entity, QuerySpec querySpec, boolean create) {
        String idString = this.getStringId(entity, create);
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, (Object)idString, (QuerySpec)null));
        BaseResponseContext context = this.executeUpdate(url, entity, (QueryAdapter)new QuerySpecAdapter(querySpec, this.katharsis.getRegistry()), create);
        return (S)context.getResponse().getEntity();
    }

    private <S extends T> String getStringId(S entity, boolean create) {
        if (this.katharsis.getPushAlways()) {
            return null;
        }
        if (create) {
            return null;
        }
        ResourceField idField = this.resourceInformation.getIdField();
        Object objectId = PropertyUtils.getProperty(entity, (String)idField.getUnderlyingName());
        return this.resourceInformation.toIdString(objectId);
    }

    public void delete(I id) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, id, (QuerySpec)null));
        this.executeDelete(url);
    }

    public Class<T> getResourceClass() {
        return this.resourceClass;
    }

    public T findOne(I id, QuerySpec querySpec) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, id, querySpec));
        return this.findOne(url);
    }

    @Override
    public ResourceList<T> findAll(QuerySpec querySpec) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, null, querySpec));
        return this.findAll(url);
    }

    @Override
    public ResourceList<T> findAll(Iterable<I> ids, QuerySpec queryPaquerySpecrams) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.resourceClass, ids, queryPaquerySpecrams));
        return this.findAll(url);
    }

    private ResourceList<T> findAll(HttpUrl url) {
        BaseResponseContext responseContext = this.executeGet(url);
        if (responseContext instanceof CollectionResponseContext) {
            CollectionResponseContext colResponseContext = (CollectionResponseContext)responseContext;
            return this.toList(colResponseContext.getResponse());
        }
        return this.toList(responseContext.getResponse());
    }

    private T findOne(HttpUrl url) {
        BaseResponseContext responseContext = this.executeGet(url);
        return (T)responseContext.getResponse().getEntity();
    }
}

