/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.client.KatharsisClient;
import io.katharsis.client.QuerySpecRelationshipRepositoryStub;
import io.katharsis.client.RelationshipRepositoryStub;
import io.katharsis.client.internal.AbstractStub;
import io.katharsis.client.response.ResourceList;
import io.katharsis.queryParams.QueryParams;
import io.katharsis.queryspec.QuerySpec;
import io.katharsis.queryspec.internal.QueryAdapter;
import io.katharsis.request.path.JsonPath;
import io.katharsis.request.path.ResourcePath;
import io.katharsis.resource.field.ResourceField;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.response.BaseResponseContext;
import io.katharsis.response.CollectionResponseContext;
import io.katharsis.response.JsonApiResponse;
import io.katharsis.response.LinkageContainer;
import io.katharsis.response.ResourceResponseContext;
import io.katharsis.utils.JsonApiUrlBuilder;
import io.katharsis.utils.PropertyUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;

public class RelationshipRepositoryStubImpl<T, I extends Serializable, D, J extends Serializable>
extends AbstractStub
implements RelationshipRepositoryStub<T, I, D, J>,
QuerySpecRelationshipRepositoryStub<T, I, D, J> {
    private Class<T> sourceClass;
    private Class<D> targetClass;
    private ResourceInformation resourceInformation;
    private RegistryEntry<?> relationshipEntry;

    public RelationshipRepositoryStubImpl(KatharsisClient client, Class<T> sourceClass, Class<D> targetClass, ResourceInformation resourceInformation, JsonApiUrlBuilder urlBuilder, RegistryEntry<?> relationshipEntry) {
        super(client, urlBuilder);
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.resourceInformation = resourceInformation;
        this.relationshipEntry = relationshipEntry;
    }

    public void setRelation(T source, J targetId, String fieldName) {
        Serializable sourceId = this.getSourceId(source);
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.sourceClass, (Object)sourceId, (QuerySpec)null, fieldName));
        this.execute(url, "PATCH", targetId);
    }

    public void setRelations(T source, Iterable<J> targetIds, String fieldName) {
        Serializable sourceId = this.getSourceId(source);
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.sourceClass, (Object)sourceId, (QuerySpec)null, fieldName));
        this.execute(url, "PATCH", targetIds);
    }

    public void addRelations(T source, Iterable<J> targetIds, String fieldName) {
        Serializable sourceId = this.getSourceId(source);
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.sourceClass, (Object)sourceId, (QuerySpec)null, fieldName));
        this.execute(url, "POST", targetIds);
    }

    public void removeRelations(T source, Iterable<J> targetIds, String fieldName) {
        Serializable sourceId = this.getSourceId(source);
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.sourceClass, (Object)sourceId, (QuerySpec)null, fieldName));
        this.execute(url, "DELETE", targetIds);
    }

    private Serializable getSourceId(T source) {
        ResourceField idField = this.resourceInformation.getIdField();
        return (Serializable)PropertyUtils.getProperty(source, (String)idField.getUnderlyingName());
    }

    public D findOneTarget(I sourceId, String fieldName, QueryParams queryParams) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.sourceClass, sourceId, queryParams, fieldName));
        BaseResponseContext responseContext = this.executeGet(url);
        return (D)responseContext.getResponse().getEntity();
    }

    @Override
    public List<D> findManyTargets(I sourceId, String fieldName, QueryParams queryParams) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.sourceClass, sourceId, queryParams, fieldName));
        BaseResponseContext responseContext = this.executeGet(url);
        return (List)responseContext.getResponse().getEntity();
    }

    public D findOneTarget(I sourceId, String fieldName, QuerySpec querySpec) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.sourceClass, sourceId, querySpec, fieldName));
        BaseResponseContext responseContext = this.executeGet(url);
        return (D)responseContext.getResponse().getEntity();
    }

    @Override
    public ResourceList<D> findManyTargets(I sourceId, String fieldName, QuerySpec querySpec) {
        HttpUrl url = HttpUrl.parse((String)this.urlBuilder.buildUrl(this.sourceClass, sourceId, querySpec, fieldName));
        BaseResponseContext responseContext = this.executeGet(url);
        return this.toList(responseContext.getResponse());
    }

    private void execute(HttpUrl requestUrl, String method, Object targetIds) {
        String requestBodyValue;
        ResourceResponseContext context;
        ResourcePath fieldPath = new ResourcePath(this.resourceInformation.getResourceType());
        JsonApiResponse response = new JsonApiResponse();
        if (targetIds instanceof Iterable) {
            ArrayList<LinkageContainer> containers = new ArrayList<LinkageContainer>();
            for (Object targetId : (Iterable)targetIds) {
                containers.add(new LinkageContainer(targetId, this.targetClass, this.relationshipEntry));
            }
            response.setEntity(containers);
            context = new CollectionResponseContext(response, (JsonPath)fieldPath, null);
        } else {
            Object targetId = targetIds;
            response.setEntity((Object)new LinkageContainer(targetId, this.targetClass, this.relationshipEntry));
            context = new ResourceResponseContext(response, (JsonPath)fieldPath, (QueryAdapter)null);
        }
        ObjectMapper objectMapper = this.katharsis.getObjectMapper();
        try {
            requestBodyValue = objectMapper.writeValueAsString((Object)context);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        Request.Builder builder = new Request.Builder().url(requestUrl);
        builder = builder.method(method, RequestBody.create(null, (String)requestBodyValue));
        this.execute(builder, false);
    }

    public Class<T> getSourceResourceClass() {
        return this.sourceClass;
    }

    public Class<D> getTargetResourceClass() {
        return this.targetClass;
    }
}

