/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.katharsis.client.ResponseBodyException;
import io.katharsis.errorhandling.ErrorData;
import io.katharsis.errorhandling.ErrorResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ErrorResponseDeserializer
extends JsonDeserializer<ErrorResponse> {
    public ErrorResponse deserialize(JsonParser jp, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        if (node == null) {
            return null;
        }
        JsonNode errorsNode = node.get("errors");
        ArrayList<ErrorData> errors = new ArrayList<ErrorData>();
        if (errorsNode != null) {
            if (!errorsNode.isArray()) {
                throw new ResponseBodyException("data field has wrong type: " + node.toString());
            }
            Iterator iterator = errorsNode.elements();
            while (iterator.hasNext()) {
                JsonNode errorNode = (JsonNode)iterator.next();
                String id = ErrorResponseDeserializer.readStringIfExists("id", errorNode);
                String aboutLink = ErrorResponseDeserializer.readAboutLink(errorNode);
                String status = ErrorResponseDeserializer.readStringIfExists("status", errorNode);
                String code = ErrorResponseDeserializer.readStringIfExists("code", errorNode);
                String title = ErrorResponseDeserializer.readStringIfExists("title", errorNode);
                String detail = ErrorResponseDeserializer.readStringIfExists("detail", errorNode);
                Map<String, Object> meta = ErrorResponseDeserializer.readMeta(errorNode, jp);
                String sourcePointer = ErrorResponseDeserializer.readSourcePointer(errorNode);
                String sourceParameter = ErrorResponseDeserializer.readSourceParameter(errorNode);
                ErrorData error = new ErrorData(id, aboutLink, status, code, title, detail, sourcePointer, sourceParameter, meta);
                errors.add(error);
            }
        }
        int httpStatus = -1;
        return new ErrorResponse(errors, httpStatus);
    }

    private static Map<String, Object> readMeta(JsonNode errorNode, JsonParser jp) throws IOException {
        JsonNode metaNode = errorNode.get("meta");
        if (metaNode != null) {
            return (Map)jp.getCodec().treeToValue((TreeNode)metaNode, Map.class);
        }
        return null;
    }

    private static String readSourcePointer(JsonNode errorNode) throws IOException {
        JsonNode node = errorNode.get("source");
        if (node != null) {
            return ErrorResponseDeserializer.readStringIfExists("pointer", node);
        }
        return null;
    }

    private static String readSourceParameter(JsonNode errorNode) throws IOException {
        JsonNode node = errorNode.get("source");
        if (node != null) {
            return ErrorResponseDeserializer.readStringIfExists("parameter", node);
        }
        return null;
    }

    private static String readAboutLink(JsonNode errorNode) throws IOException {
        JsonNode node = errorNode.get("links");
        if (node != null) {
            return ErrorResponseDeserializer.readStringIfExists("about", node);
        }
        return null;
    }

    private static String readStringIfExists(String fieldName, JsonNode errorNode) throws IOException {
        JsonNode node = errorNode.get(fieldName);
        if (node != null) {
            return node.asText();
        }
        return null;
    }

    public Class<ErrorResponse> handledType() {
        return ErrorResponse.class;
    }
}

