/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.katharsis.client.response.JsonLinksInformation;
import io.katharsis.client.response.JsonMetaInformation;
import io.katharsis.dispatcher.controller.resource.ResourceUpsert;
import io.katharsis.jackson.exception.JsonDeserializationException;
import io.katharsis.queryspec.internal.QueryAdapter;
import io.katharsis.repository.RepositoryMethodParameterProvider;
import io.katharsis.request.dto.DataBody;
import io.katharsis.request.dto.RequestBody;
import io.katharsis.request.path.JsonPath;
import io.katharsis.resource.information.ResourceInformation;
import io.katharsis.resource.registry.RegistryEntry;
import io.katharsis.resource.registry.ResourceRegistry;
import io.katharsis.response.BaseResponseContext;
import io.katharsis.response.CollectionResponseContext;
import io.katharsis.response.JsonApiResponse;
import io.katharsis.response.LinksInformation;
import io.katharsis.response.MetaInformation;
import io.katharsis.response.ResourceResponseContext;
import io.katharsis.utils.parser.TypeParser;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class BaseResponseDeserializer
extends JsonDeserializer<BaseResponseContext> {
    private static final String INCLUDED_FIELD_NAME = "included";
    private static final String DATA_FIELD_NAME = "data";
    private static final String META_FIELD_NAME = "meta";
    private static final String LINKS_FIELD_NAME = "links";
    private ResourceRegistry resourceRegistry;
    private ObjectMapper objectMapper;
    private TypeParser typeParser = new TypeParser();

    public BaseResponseDeserializer(ResourceRegistry resourceRegistry, ObjectMapper objectMapper) {
        this.resourceRegistry = resourceRegistry;
        this.objectMapper = objectMapper;
    }

    public BaseResponseContext deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        if (node == null) {
            return null;
        }
        JsonNode data = node.get(DATA_FIELD_NAME);
        JsonNode included = node.get(INCLUDED_FIELD_NAME);
        LinksInformation links = this.readLinks(node);
        MetaInformation meta = this.readMeta(node);
        if (data == null) {
            throw new IllegalStateException("no data received");
        }
        ClientResourceUpsert upsert = new ClientResourceUpsert(this.resourceRegistry, this.typeParser, this.objectMapper);
        ResourceBodies dataBodies = upsert.parse(data, jp);
        ResourceBodies includedBodies = upsert.parse(included, jp);
        upsert.allocateResources(dataBodies);
        upsert.allocateResources(includedBodies);
        upsert.setRelations(dataBodies);
        upsert.setRelations(includedBodies);
        JsonApiResponse response = new JsonApiResponse();
        response.setLinksInformation(links);
        response.setMetaInformation(meta);
        if (dataBodies.isCollection) {
            response.setEntity(dataBodies.resources);
            return new CollectionResponseContext(response, null, null);
        }
        if (dataBodies.resources.size() == 1) {
            response.setEntity(dataBodies.resources.get(0));
        } else {
            response.setEntity(null);
        }
        return new ResourceResponseContext(response, -1);
    }

    private LinksInformation readLinks(JsonNode node) {
        JsonNode data = node.get(LINKS_FIELD_NAME);
        if (data != null) {
            return new JsonLinksInformation(data);
        }
        return null;
    }

    private MetaInformation readMeta(JsonNode node) {
        JsonNode data = node.get(META_FIELD_NAME);
        if (data != null) {
            return new JsonMetaInformation(data);
        }
        return null;
    }

    class ResourceBodies {
        ArrayList<Object> resources = new ArrayList();
        ArrayList<DataBody> dataBodies = new ArrayList();
        boolean isCollection = false;

        ResourceBodies() {
        }
    }

    public static class ClientDataBody
    extends DataBody {
        private JsonNode links;
        private JsonNode meta;

        public JsonNode getLinks() {
            return this.links;
        }

        public void setLinks(JsonNode links) {
            this.links = links;
        }

        public JsonNode getMeta() {
            return this.meta;
        }

        public void setMeta(JsonNode meta) {
            this.meta = meta;
        }
    }

    class ClientResourceUpsert
    extends ResourceUpsert {
        private HashMap<Object, Object> resourceMap;

        public ClientResourceUpsert(ResourceRegistry resourceRegistry, TypeParser typeParser, ObjectMapper objectMapper) {
            super(resourceRegistry, typeParser, objectMapper);
            this.resourceMap = new HashMap();
        }

        public String getUID(DataBody body) {
            return body.getType() + "#" + body.getId();
        }

        public String getUID(RegistryEntry<?> entry, Serializable id) {
            return entry.getResourceInformation().getResourceType() + "#" + id;
        }

        public void setRelations(ResourceBodies dataBodies) {
            for (DataBody body : dataBodies.dataBodies) {
                String uid = this.getUID(body);
                Object resource = this.resourceMap.get(uid);
                RegistryEntry registryEntry = BaseResponseDeserializer.this.resourceRegistry.getEntry(body.getType());
                QueryAdapter queryAdapter = null;
                RepositoryMethodParameterProvider parameterProvider = null;
                this.setRelations(resource, registryEntry, body, queryAdapter, parameterProvider);
            }
        }

        protected Object fetchRelatedObject(RegistryEntry entry, Serializable relationId, RepositoryMethodParameterProvider parameterProvider, QueryAdapter queryAdapter) {
            String uid = this.getUID(entry, relationId);
            Object relatedResource = this.resourceMap.get(uid);
            if (relatedResource != null) {
                return relatedResource;
            }
            return null;
        }

        public void allocateResources(ResourceBodies dataBodies) {
            for (DataBody body : dataBodies.dataBodies) {
                RegistryEntry registryEntry = BaseResponseDeserializer.this.resourceRegistry.getEntry(body.getType());
                ResourceInformation resourceInformation = registryEntry.getResourceInformation();
                Object resource = this.newResource(resourceInformation, body);
                this.setId(body, resource, resourceInformation);
                this.setAttributes(body, resource, resourceInformation);
                dataBodies.resources.add(resource);
                String uid = this.getUID(body);
                this.resourceMap.put(uid, resource);
            }
        }

        public boolean isAcceptable(JsonPath jsonPath, String requestType) {
            throw new IllegalStateException();
        }

        public BaseResponseContext handle(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, RequestBody requestBody) {
            throw new IllegalStateException();
        }

        public ResourceBodies parse(JsonNode node, JsonParser jp) throws JsonProcessingException {
            ResourceBodies bodies = new ResourceBodies();
            if (node != null) {
                if (node.isArray()) {
                    Iterator nodeIterator = node.iterator();
                    while (nodeIterator.hasNext()) {
                        DataBody newLinkage = (DataBody)jp.getCodec().treeToValue((TreeNode)nodeIterator.next(), ClientDataBody.class);
                        bodies.dataBodies.add(newLinkage);
                    }
                    bodies.isCollection = true;
                } else if (node.isObject()) {
                    bodies.dataBodies.add((DataBody)jp.getCodec().treeToValue((TreeNode)node, ClientDataBody.class));
                } else if (!node.isNull()) {
                    throw new JsonDeserializationException("data field has wrong type: " + node.toString());
                }
            }
            return bodies;
        }
    }
}

