/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.client.http.okhttp;

import io.katharsis.client.http.HttpAdapter;
import io.katharsis.client.http.okhttp.OkHttpAdapterListener;
import java.util.concurrent.CopyOnWriteArrayList;
import okhttp3.OkHttpClient;

public class OkHttpAdapter
implements HttpAdapter {
    private OkHttpClient impl;
    private CopyOnWriteArrayList<OkHttpAdapterListener> listeners = new CopyOnWriteArrayList();

    public void addListener(OkHttpAdapterListener listener) {
        if (this.impl != null) {
            throw new IllegalStateException("already initialized");
        }
        this.listeners.add(listener);
    }

    public OkHttpClient getImplementation() {
        if (this.impl == null) {
            this.initImpl();
        }
        return this.impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initImpl() {
        OkHttpAdapter okHttpAdapter = this;
        synchronized (okHttpAdapter) {
            if (this.impl == null) {
                OkHttpClient.Builder builder = new OkHttpClient.Builder();
                for (OkHttpAdapterListener listener : this.listeners) {
                    listener.onBuild(builder);
                }
                this.impl = builder.build();
            }
        }
    }
}

