/*
 * Decompiled with CFR 0.152.
 */
package kamon.apm.sleuth;

import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.core.util.internal.logging.InternalLogger;
import io.micrometer.core.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kamon.apm.KamonApmConfig;
import kamon.apm.KamonApmMeterRegistry;
import kamon.apm.ingestion.v1.traces.Span;
import kamon.apm.ingestion.v1.traces.SpanBatch;
import kamon.apm.ingestion.v1.traces.SpanKind;
import kamon.apm.sleuth.KamonApmSpanReporterConfig;
import zipkin2.reporter.Reporter;

public class KamonApmSpanReporter
implements Reporter<zipkin2.Span>,
Closeable {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(KamonApmMeterRegistry.class);
    private final ScheduledExecutorService scheduler;
    private final ArrayBlockingQueue<zipkin2.Span> pendingSpans;
    private final KamonApmConfig apmConfig;
    private final HttpSender httpSender;
    private final String kamonApmIngestUrl;

    public KamonApmSpanReporter(KamonApmConfig apmConfig, KamonApmSpanReporterConfig spanReporterConfig) {
        this.apmConfig = apmConfig;
        String cleanBaseUrl = apmConfig.baseUrl().endsWith("/") ? apmConfig.baseUrl() : apmConfig.baseUrl().concat("/");
        this.kamonApmIngestUrl = cleanBaseUrl.concat("v1/tracing/ingest");
        this.pendingSpans = new ArrayBlockingQueue(spanReporterConfig.bufferSize());
        this.httpSender = new HttpUrlConnectionSender(Duration.ofSeconds(3L), Duration.ofSeconds(10L));
        this.scheduler = Executors.newScheduledThreadPool(1, new SpanReporterThreadFactory());
        this.scheduler.scheduleAtFixedRate(this::flush, 5L, spanReporterConfig.flushInterval().getSeconds(), TimeUnit.SECONDS);
    }

    public void report(zipkin2.Span span) {
        this.pendingSpans.offer(span);
    }

    @Override
    public void close() throws IOException {
        this.scheduler.shutdown();
    }

    private void flush() {
        try {
            LinkedList<zipkin2.Span> spansToFlush = new LinkedList<zipkin2.Span>();
            this.pendingSpans.drainTo(spansToFlush);
            if (!spansToFlush.isEmpty()) {
                byte[] spanBatchData = SpanBatch.newBuilder().setServiceName(this.apmConfig.applicationName()).setApiKey(this.apmConfig.apiKey()).setHost(this.apmConfig.host()).setInstance(this.apmConfig.instance()).setAgent("micrometer").addAllSpans(this.convertSpans(spansToFlush)).build().toByteArray();
                HttpSender.Response response = this.httpSender.post(this.kamonApmIngestUrl).withContent("application/octet-stream", spanBatchData).send();
                if (!response.isSuccessful()) {
                    this.logger.error("Publishing spans to Kamon APM failed with HTTP Status [{}]", (Object)response.code());
                }
            }
        }
        catch (Throwable e) {
            this.logger.error("Failed to publish spans to Kamon APM", e);
        }
    }

    private List<Span> convertSpans(List<zipkin2.Span> zipkinSpans) {
        return zipkinSpans.stream().map(s -> {
            boolean hasError = s.tags().getOrDefault("error", "false").equals("true");
            String parentId = s.parentId() == null ? "" : s.parentId();
            Span.Builder spanBuilder = Span.newBuilder().setId(s.id()).setParentId(parentId).setTraceId(s.traceId()).setKind(s.kind() == null ? SpanKind.INTERNAL : SpanKind.valueOf(s.kind().toString())).setOperationName(s.name()).setStartMicros(s.timestampAsLong()).setEndMicros(s.durationAsLong() + s.timestampAsLong()).setHasError(hasError);
            if (!s.tags().isEmpty()) {
                spanBuilder.putAllTags(s.tags());
            }
            return spanBuilder.build();
        }).collect(Collectors.toList());
    }

    private static class SpanReporterThreadFactory
    implements ThreadFactory {
        private SpanReporterThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("kamon-apm-span-reporter-flusher");
            thread.setDaemon(true);
            return thread;
        }
    }
}

