package kamino

import org.asynchttpclient.ListenableFuture
import scala.concurrent.{ExecutionContextExecutor, Promise, Future}

package object sanguijuela {

  implicit class RichListenableFuture[T](lf: ListenableFuture[T]){
    def toFuture(dispatcher: ExecutionContextExecutor) : Future[T] = {
      val p = Promise[T]()
      lf.addListener(new Runnable {
        override def run(): Unit = {
          try {
            p.success(lf.get())
          } catch {
            case anyException: Throwable => p.failure(anyException)
          }
        }
      }, dispatcher)
      p.future
    }
  }
}
