package kamino.sanguijuela

import java.nio.ByteBuffer

import scala.collection.mutable



class OffHeapSnapshotStorage(capacity: Int) {
  var storage = List[ByteBuffer]()


  def put(data: Array[Byte]) = {
    if(storage.size >= capacity) storage = storage.tail
    val buff = ByteBuffer.allocateDirect(data.length)
    buff.put(data)
    buff.flip()
    storage = storage:+buff
  }

  def popHead(): Option[Array[Byte]] = {
    val buff = storage.headOption
      .map(b => {
        val newBuff = ByteBuffer.allocate(b.capacity())
        newBuff.put(b)
        newBuff.flip()
        newBuff.array()
      })
    storage = storage.tail
    buff
  }

  def getHead(): Option[Array[Byte]] =
    storage.headOption
      .map(b => {
        val newBuff = ByteBuffer.allocate(b.capacity())
        newBuff.put(b)
        newBuff.flip()
        b.flip()
        newBuff.array()
      })
}