package kamino.sanguijuela

import com.esotericsoftware.kryo.Kryo
import com.esotericsoftware.kryo.io.{Output, Input}



object ModelSerializer {
  private val kryo = new  ThreadLocal[Kryo] {
    override def initialValue(): Kryo = new Kryo()
  }

  def unpack[T](bytes: Array[Byte], clz: Class[T]): T =
    kryo.get.readObject(new Input(bytes),clz)

  def pack[T](data: T): Array[Byte] = {
    val buffer = new Array[Byte](10485760)// TODO: Use some sort of nice buffer.
    val output = new Output(buffer)
    kryo.get.writeObject(output,data)
    output.toBytes
  }
}