/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.objenesis.strategy;

import shaded.org.objenesis.instantiator.ObjectInstantiator;
import shaded.org.objenesis.instantiator.android.Android10Instantiator;
import shaded.org.objenesis.instantiator.android.Android17Instantiator;
import shaded.org.objenesis.instantiator.android.Android18Instantiator;
import shaded.org.objenesis.instantiator.gcj.GCJInstantiator;
import shaded.org.objenesis.instantiator.jrockit.JRockitLegacyInstantiator;
import shaded.org.objenesis.instantiator.perc.PercInstantiator;
import shaded.org.objenesis.instantiator.sun.SunReflectionFactoryInstantiator;
import shaded.org.objenesis.instantiator.sun.UnsafeFactoryInstantiator;
import shaded.org.objenesis.strategy.BaseInstantiatorStrategy;
import shaded.org.objenesis.strategy.PlatformDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (PlatformDescription.isThisJVM("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            return new SunReflectionFactoryInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("BEA")) {
            if (!(!PlatformDescription.VM_VERSION.startsWith("1.4") || PlatformDescription.VENDOR_VERSION.startsWith("R") || PlatformDescription.VM_INFO != null && PlatformDescription.VM_INFO.startsWith("R25.1") && PlatformDescription.VM_INFO.startsWith("R25.2"))) {
                return new JRockitLegacyInstantiator<T>(type);
            }
            return new SunReflectionFactoryInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("Dalvik")) {
            if (PlatformDescription.ANDROID_VERSION <= 10) {
                return new Android10Instantiator<T>(type);
            }
            if (PlatformDescription.ANDROID_VERSION <= 17) {
                return new Android17Instantiator<T>(type);
            }
            return new Android18Instantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("GNU libgcj")) {
            return new GCJInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("PERC")) {
            return new PercInstantiator<T>(type);
        }
        return new UnsafeFactoryInstantiator<T>(type);
    }
}

