/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.netty.resolver.dns;

import java.net.InetSocketAddress;
import shaded.io.netty.resolver.dns.DnsServerAddressStream;
import shaded.io.netty.resolver.dns.SequentialDnsServerAddressStream;
import shaded.io.netty.util.internal.ThreadLocalRandom;

final class ShuffledDnsServerAddressStream
implements DnsServerAddressStream {
    private final InetSocketAddress[] addresses;
    private int i;

    ShuffledDnsServerAddressStream(InetSocketAddress[] addresses) {
        this.addresses = (InetSocketAddress[])addresses.clone();
        this.shuffle();
    }

    private void shuffle() {
        InetSocketAddress[] addresses = this.addresses;
        ThreadLocalRandom r = ThreadLocalRandom.current();
        for (int i = addresses.length - 1; i >= 0; --i) {
            InetSocketAddress tmp = addresses[i];
            int j = r.nextInt(i + 1);
            addresses[i] = addresses[j];
            addresses[j] = tmp;
        }
    }

    @Override
    public InetSocketAddress next() {
        int i = this.i;
        InetSocketAddress next = this.addresses[i];
        if (++i < this.addresses.length) {
            this.i = i;
        } else {
            this.i = 0;
            this.shuffle();
        }
        return next;
    }

    public String toString() {
        return SequentialDnsServerAddressStream.toString("shuffled", this.i, this.addresses);
    }
}

