/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.netty.resolver.dns;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import shaded.io.netty.channel.EventLoop;
import shaded.io.netty.resolver.dns.DnsCache;
import shaded.io.netty.resolver.dns.DnsCacheEntry;
import shaded.io.netty.util.internal.ObjectUtil;
import shaded.io.netty.util.internal.ObjectUtil2;
import shaded.io.netty.util.internal.OneTimeTask;
import shaded.io.netty.util.internal.PlatformDependent;

public class DefaultDnsCache
implements DnsCache {
    private final ConcurrentMap<String, List<DnsCacheEntry>> resolveCache = PlatformDependent.newConcurrentHashMap();
    private final int minTtl;
    private final int maxTtl;
    private final int negativeTtl;

    public DefaultDnsCache() {
        this(0, Integer.MAX_VALUE, 0);
    }

    public DefaultDnsCache(int minTtl, int maxTtl, int negativeTtl) {
        this.minTtl = ObjectUtil2.checkPositiveOrZero(minTtl, "minTtl");
        this.maxTtl = ObjectUtil2.checkPositiveOrZero(maxTtl, "maxTtl");
        if (minTtl > maxTtl) {
            throw new IllegalArgumentException("minTtl: " + minTtl + ", maxTtl: " + maxTtl + " (expected: 0 <= minTtl <= maxTtl)");
        }
        this.negativeTtl = ObjectUtil2.checkPositiveOrZero(negativeTtl, "negativeTtl");
    }

    public int minTtl() {
        return this.minTtl;
    }

    public int maxTtl() {
        return this.maxTtl;
    }

    public int negativeTtl() {
        return this.negativeTtl;
    }

    @Override
    public void clear() {
        Iterator i = this.resolveCache.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            i.remove();
            DefaultDnsCache.cancelExpiration((List)e.getValue());
        }
    }

    @Override
    public boolean clear(String hostname) {
        ObjectUtil.checkNotNull(hostname, "hostname");
        boolean removed = false;
        Iterator i = this.resolveCache.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (!((String)e.getKey()).equals(hostname)) continue;
            i.remove();
            DefaultDnsCache.cancelExpiration((List)e.getValue());
            removed = true;
        }
        return removed;
    }

    @Override
    public List<DnsCacheEntry> get(String hostname) {
        ObjectUtil.checkNotNull(hostname, "hostname");
        return (List)this.resolveCache.get(hostname);
    }

    private List<DnsCacheEntry> cachedEntries(String hostname) {
        ArrayList newEntries;
        ArrayList oldEntries = (ArrayList)this.resolveCache.get(hostname);
        ArrayList entries = oldEntries == null ? ((oldEntries = (List)this.resolveCache.putIfAbsent(hostname, newEntries = new ArrayList(8))) != null ? oldEntries : newEntries) : oldEntries;
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cache(String hostname, InetAddress address, long originalTtl, EventLoop loop) {
        if (this.maxTtl == 0) {
            return;
        }
        ObjectUtil.checkNotNull(hostname, "hostname");
        ObjectUtil.checkNotNull(address, "address");
        ObjectUtil.checkNotNull(loop, "loop");
        int ttl = Math.max(this.minTtl, (int)Math.min((long)this.maxTtl, originalTtl));
        List<DnsCacheEntry> entries = this.cachedEntries(hostname);
        DnsCacheEntry e = new DnsCacheEntry(hostname, address);
        List<DnsCacheEntry> list = entries;
        synchronized (list) {
            DnsCacheEntry firstEntry;
            if (!entries.isEmpty() && (firstEntry = entries.get(0)).cause() != null) {
                assert (entries.size() == 1);
                firstEntry.cancelExpiration();
                entries.clear();
            }
            entries.add(e);
        }
        this.scheduleCacheExpiration(entries, e, ttl, loop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cache(String hostname, Throwable cause, EventLoop loop) {
        if (this.negativeTtl == 0) {
            return;
        }
        ObjectUtil.checkNotNull(hostname, "hostname");
        ObjectUtil.checkNotNull(cause, "cause");
        ObjectUtil.checkNotNull(loop, "loop");
        List<DnsCacheEntry> entries = this.cachedEntries(hostname);
        DnsCacheEntry e = new DnsCacheEntry(hostname, cause);
        List<DnsCacheEntry> list = entries;
        synchronized (list) {
            int numEntries = entries.size();
            for (int i = 0; i < numEntries; ++i) {
                entries.get(i).cancelExpiration();
            }
            entries.clear();
            entries.add(e);
        }
        this.scheduleCacheExpiration(entries, e, this.negativeTtl, loop);
    }

    private static void cancelExpiration(List<DnsCacheEntry> entries) {
        int numEntries = entries.size();
        for (int i = 0; i < numEntries; ++i) {
            entries.get(i).cancelExpiration();
        }
    }

    private void scheduleCacheExpiration(final List<DnsCacheEntry> entries, final DnsCacheEntry e, int ttl, EventLoop loop) {
        e.scheduleExpiration(loop, new OneTimeTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = entries;
                synchronized (list) {
                    entries.remove(e);
                    if (entries.isEmpty()) {
                        DefaultDnsCache.this.resolveCache.remove(e.hostname());
                    }
                }
            }
        }, ttl, TimeUnit.SECONDS);
    }

    public String toString() {
        return "DefaultDnsCache(minTtl=" + this.minTtl + ", maxTtl=" + this.maxTtl + ", negativeTtl=" + this.negativeTtl + ", cached resolved hostname=" + this.resolveCache.size() + ")";
    }
}

