/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.netty.handler.ssl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import shaded.io.netty.handler.ssl.CipherSuiteFilter;
import shaded.io.netty.util.internal.InternalThreadLocalMap;

public final class SupportedCipherSuiteFilter
implements CipherSuiteFilter {
    public static final SupportedCipherSuiteFilter INSTANCE = new SupportedCipherSuiteFilter();

    private SupportedCipherSuiteFilter() {
    }

    @Override
    public String[] filterCipherSuites(Iterable<String> ciphers, List<String> defaultCiphers, Set<String> supportedCiphers) {
        ArrayList<String> newCiphers;
        if (defaultCiphers == null) {
            throw new NullPointerException("defaultCiphers");
        }
        if (supportedCiphers == null) {
            throw new NullPointerException("supportedCiphers");
        }
        if (ciphers == null) {
            newCiphers = InternalThreadLocalMap.get().arrayList(defaultCiphers.size());
            ciphers = defaultCiphers;
        } else {
            newCiphers = InternalThreadLocalMap.get().arrayList(supportedCiphers.size());
        }
        for (String c : ciphers) {
            if (c == null) break;
            if (!supportedCiphers.contains(c)) continue;
            newCiphers.add(c);
        }
        return newCiphers.toArray(new String[newCiphers.size()]);
    }
}

