/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.netty.handler.codec.http.websocketx;

import java.net.URI;
import java.util.List;
import shaded.io.netty.channel.ChannelHandlerContext;
import shaded.io.netty.channel.ChannelPipeline;
import shaded.io.netty.handler.codec.http.HttpHeaders;
import shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import shaded.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandshakeHandler;
import shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import shaded.io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler;
import shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;

public class WebSocketClientProtocolHandler
extends WebSocketProtocolHandler {
    private final WebSocketClientHandshaker handshaker;
    private final boolean handleCloseFrames;

    public WebSocketClientHandshaker handshaker() {
        return this.handshaker;
    }

    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean handleCloseFrames) {
        this(WebSocketClientHandshakerFactory.newHandshaker(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength), handleCloseFrames);
    }

    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, true);
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, boolean handleCloseFrames) {
        this.handshaker = handshaker;
        this.handleCloseFrames = handleCloseFrames;
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker) {
        this(handshaker, true);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
        if (this.handleCloseFrames && frame instanceof CloseWebSocketFrame) {
            ctx.close();
            return;
        }
        super.decode(ctx, frame, out);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        ChannelPipeline cp = ctx.pipeline();
        if (cp.get(WebSocketClientProtocolHandshakeHandler.class) == null) {
            ctx.pipeline().addBefore(ctx.name(), WebSocketClientProtocolHandshakeHandler.class.getName(), new WebSocketClientProtocolHandshakeHandler(this.handshaker));
        }
    }

    public static enum ClientHandshakeStateEvent {
        HANDSHAKE_ISSUED,
        HANDSHAKE_COMPLETE;

    }
}

