/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.esotericsoftware.kryo.io;

import java.io.OutputStream;
import java.nio.ByteOrder;
import shaded.com.esotericsoftware.kryo.KryoException;
import shaded.com.esotericsoftware.kryo.io.Output;
import shaded.com.esotericsoftware.kryo.util.UnsafeUtil;
import shaded.com.esotericsoftware.kryo.util.Util;

public final class UnsafeOutput
extends Output {
    private boolean supportVarInts = false;
    private static final boolean isLittleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);

    public UnsafeOutput() {
    }

    public UnsafeOutput(int bufferSize) {
        this(bufferSize, bufferSize);
    }

    public UnsafeOutput(int bufferSize, int maxBufferSize) {
        super(bufferSize, maxBufferSize);
    }

    public UnsafeOutput(byte[] buffer) {
        this(buffer, buffer.length);
    }

    public UnsafeOutput(byte[] buffer, int maxBufferSize) {
        super(buffer, maxBufferSize);
    }

    public UnsafeOutput(OutputStream outputStream) {
        super(outputStream);
    }

    public UnsafeOutput(OutputStream outputStream, int bufferSize) {
        super(outputStream, bufferSize);
    }

    public final void writeInt(int value) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe().putInt(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, value);
        this.position += 4;
    }

    private final void writeLittleEndianInt(int val) {
        if (isLittleEndian) {
            this.writeInt(val);
        } else {
            this.writeInt(Util.swapInt(val));
        }
    }

    public final void writeFloat(float value) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe().putFloat(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, value);
        this.position += 4;
    }

    public final void writeShort(int value) throws KryoException {
        this.require(2);
        UnsafeUtil.unsafe().putShort(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, (short)value);
        this.position += 2;
    }

    public final void writeLong(long value) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe().putLong(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, value);
        this.position += 8;
    }

    private final void writeLittleEndianLong(long val) {
        if (isLittleEndian) {
            this.writeLong(val);
        } else {
            this.writeLong(Util.swapLong(val));
        }
    }

    public final void writeDouble(double value) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe().putDouble(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, value);
        this.position += 8;
    }

    public final void writeChar(char value) throws KryoException {
        this.require(2);
        UnsafeUtil.unsafe().putChar(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, value);
        this.position += 2;
    }

    public final int writeInt(int value, boolean optimizePositive) throws KryoException {
        if (!this.supportVarInts) {
            this.writeInt(value);
            return 4;
        }
        return this.writeVarInt(value, optimizePositive);
    }

    public final int writeLong(long value, boolean optimizePositive) throws KryoException {
        if (!this.supportVarInts) {
            this.writeLong(value);
            return 8;
        }
        return this.writeVarLong(value, optimizePositive);
    }

    public final int writeVarInt(int val, boolean optimizePositive) throws KryoException {
        int value = val;
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        int varInt = 0;
        varInt = value & 0x7F;
        if ((value >>>= 7) == 0) {
            this.write(varInt);
            return 1;
        }
        varInt |= 0x80;
        varInt |= (value & 0x7F) << 8;
        if ((value >>>= 7) == 0) {
            this.writeLittleEndianInt(varInt);
            this.position -= 2;
            return 2;
        }
        varInt |= 0x8000;
        varInt |= (value & 0x7F) << 16;
        if ((value >>>= 7) == 0) {
            this.writeLittleEndianInt(varInt);
            --this.position;
            return 3;
        }
        varInt |= 0x800000;
        varInt |= (value & 0x7F) << 24;
        if ((value >>>= 7) == 0) {
            this.writeLittleEndianInt(varInt);
            this.position -= 0;
            return 4;
        }
        long varLong = (long)(varInt |= Integer.MIN_VALUE) | (long)(value & 0x7F) << 32;
        varInt = (int)((long)varInt & 0xFFFFFFFFL);
        this.writeLittleEndianLong(varLong);
        this.position -= 3;
        return 5;
    }

    public final int writeVarLong(long value, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        int varInt = 0;
        varInt = (int)(value & 0x7FL);
        if ((value >>>= 7) == 0L) {
            this.writeByte(varInt);
            return 1;
        }
        varInt |= 0x80;
        varInt = (int)((long)varInt | value << 8);
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianInt(varInt);
            this.position -= 2;
            return 2;
        }
        varInt |= 0x8000;
        varInt = (int)((long)varInt | value << 16);
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianInt(varInt);
            --this.position;
            return 3;
        }
        varInt |= 0x800000;
        varInt = (int)((long)varInt | value << 24);
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianInt(varInt);
            this.position -= 0;
            return 4;
        }
        long varLong = (long)(varInt |= Integer.MIN_VALUE) | value << 32;
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianLong(varLong);
            this.position -= 3;
            return 5;
        }
        varLong |= 0x80L;
        varLong = (long)varInt | value << 40;
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianLong(varLong);
            this.position -= 2;
            return 6;
        }
        varLong |= 0x8000L;
        varLong = (long)varInt | value << 48;
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianLong(varLong);
            --this.position;
            return 7;
        }
        varLong |= 0x800000L;
        varLong = (long)varInt | value << 56;
        if ((value >>>= 7) == 0L) {
            this.writeLittleEndianLong(varLong);
            return 8;
        }
        this.writeLittleEndianLong(varLong |= Integer.MIN_VALUE);
        this.write((byte)(value >>> 7));
        return 9;
    }

    public final void writeInts(int[] object, boolean optimizePositive) throws KryoException {
        if (!this.supportVarInts) {
            int bytesToCopy = object.length << 2;
            this.writeBytes(object, UnsafeUtil.intArrayBaseOffset, 0L, bytesToCopy);
        } else {
            super.writeInts(object, optimizePositive);
        }
    }

    public final void writeLongs(long[] object, boolean optimizePositive) throws KryoException {
        if (!this.supportVarInts) {
            int bytesToCopy = object.length << 3;
            this.writeBytes(object, UnsafeUtil.longArrayBaseOffset, 0L, bytesToCopy);
        } else {
            super.writeLongs(object, optimizePositive);
        }
    }

    public final void writeInts(int[] object) throws KryoException {
        int bytesToCopy = object.length << 2;
        this.writeBytes(object, UnsafeUtil.intArrayBaseOffset, 0L, bytesToCopy);
    }

    public final void writeLongs(long[] object) throws KryoException {
        int bytesToCopy = object.length << 3;
        this.writeBytes(object, UnsafeUtil.longArrayBaseOffset, 0L, bytesToCopy);
    }

    public final void writeFloats(float[] object) throws KryoException {
        int bytesToCopy = object.length << 2;
        this.writeBytes(object, UnsafeUtil.floatArrayBaseOffset, 0L, bytesToCopy);
    }

    public final void writeShorts(short[] object) throws KryoException {
        int bytesToCopy = object.length << 1;
        this.writeBytes(object, UnsafeUtil.shortArrayBaseOffset, 0L, bytesToCopy);
    }

    public final void writeChars(char[] object) throws KryoException {
        int bytesToCopy = object.length << 1;
        this.writeBytes(object, UnsafeUtil.charArrayBaseOffset, 0L, bytesToCopy);
    }

    public final void writeDoubles(double[] object) throws KryoException {
        int bytesToCopy = object.length << 3;
        this.writeBytes(object, UnsafeUtil.doubleArrayBaseOffset, 0L, bytesToCopy);
    }

    public final void writeBytes(Object obj, long offset, long count) throws KryoException {
        this.writeBytes(obj, 0L, offset, count);
    }

    private final void writeBytes(Object srcArray, long srcArrayTypeOffset, long srcOffset, long count) throws KryoException {
        int copyCount = Math.min(this.capacity - this.position, (int)count);
        while (true) {
            UnsafeUtil.unsafe().copyMemory(srcArray, srcArrayTypeOffset + srcOffset, this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, copyCount);
            this.position += copyCount;
            if ((count -= (long)copyCount) == 0L) {
                return;
            }
            srcOffset += (long)copyCount;
            copyCount = Math.min(this.capacity, (int)count);
            this.require(copyCount);
        }
    }

    public boolean supportVarInts() {
        return this.supportVarInts;
    }

    public void supportVarInts(boolean supportVarInts) {
        this.supportVarInts = supportVarInts;
    }
}

