/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.netty.NettyResponse;
import org.asynchttpclient.webdav.WebDavResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class WebDavCompletionHandlerBase<T>
implements AsyncHandler<T> {
    private final Logger logger = LoggerFactory.getLogger(AsyncCompletionHandlerBase.class);
    private HttpResponseStatus status;
    private HttpResponseHeaders headers;
    private final List<HttpResponseBodyPart> bodyParts = Collections.synchronizedList(new ArrayList());

    @Override
    public final AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        this.bodyParts.add(content);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
        this.status = status;
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.headers = headers;
        return AsyncHandler.State.CONTINUE;
    }

    private Document readXMLResponse(InputStream stream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            document = factory.newDocumentBuilder().parse(stream);
            this.parse(document);
        }
        catch (SAXException e) {
            this.logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            this.logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        return document;
    }

    private void parse(Document document) {
        Element element = document.getDocumentElement();
        NodeList statusNode = element.getElementsByTagName("status");
        for (int i = 0; i < statusNode.getLength(); ++i) {
            Node node = statusNode.item(i);
            String value = node.getFirstChild().getNodeValue();
            int statusCode = Integer.valueOf(value.substring(value.indexOf(" "), value.lastIndexOf(" ")).trim());
            String statusText = value.substring(value.lastIndexOf(" "));
            this.status = new HttpStatusWrapper(this.status, statusText, statusCode);
        }
    }

    @Override
    public final T onCompleted() throws Exception {
        if (this.status != null) {
            Document document = null;
            if (this.status.getStatusCode() == 207) {
                document = this.readXMLResponse(new NettyResponse(this.status, this.headers, this.bodyParts).getResponseBodyAsStream());
            }
            return this.onCompleted(new WebDavResponse(new NettyResponse(this.status, this.headers, this.bodyParts), document));
        }
        throw new IllegalStateException("Status is null");
    }

    @Override
    public void onThrowable(Throwable t) {
        this.logger.debug(t.getMessage(), t);
    }

    public abstract T onCompleted(WebDavResponse var1) throws Exception;

    private class HttpStatusWrapper
    extends HttpResponseStatus {
        private final HttpResponseStatus wrapped;
        private final String statusText;
        private final int statusCode;

        public HttpStatusWrapper(HttpResponseStatus wrapper, String statusText, int statusCode) {
            super(wrapper.getUri(), null);
            this.wrapped = wrapper;
            this.statusText = statusText;
            this.statusCode = statusCode;
        }

        @Override
        public int getStatusCode() {
            return this.statusText == null ? this.wrapped.getStatusCode() : this.statusCode;
        }

        @Override
        public String getStatusText() {
            return this.statusText == null ? this.wrapped.getStatusText() : this.statusText;
        }

        @Override
        public String getProtocolName() {
            return this.wrapped.getProtocolName();
        }

        @Override
        public int getProtocolMajorVersion() {
            return this.wrapped.getProtocolMajorVersion();
        }

        @Override
        public int getProtocolMinorVersion() {
            return this.wrapped.getProtocolMinorVersion();
        }

        @Override
        public String getProtocolText() {
            return this.wrapped.getStatusText();
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return this.wrapped.getRemoteAddress();
        }

        @Override
        public SocketAddress getLocalAddress() {
            return this.wrapped.getLocalAddress();
        }
    }
}

