/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart.part;

import java.nio.ByteBuffer;
import shaded.io.netty.buffer.ByteBuf;

public interface PartVisitor {
    public void withBytes(byte[] var1);

    public void withByte(byte var1);

    public static class ByteBufVisitor
    implements PartVisitor {
        private final ByteBuf target;

        public ByteBufVisitor(ByteBuf target) {
            this.target = target;
        }

        @Override
        public void withBytes(byte[] bytes) {
            this.target.writeBytes(bytes);
        }

        @Override
        public void withByte(byte b) {
            this.target.writeByte(b);
        }
    }

    public static class ByteBufferVisitor
    implements PartVisitor {
        private final ByteBuffer target;

        public ByteBufferVisitor(ByteBuffer target) {
            this.target = target;
        }

        @Override
        public void withBytes(byte[] bytes) {
            this.target.put(bytes);
        }

        @Override
        public void withByte(byte b) {
            this.target.put(b);
        }
    }

    public static class CounterPartVisitor
    implements PartVisitor {
        private int count = 0;

        @Override
        public void withBytes(byte[] bytes) {
            this.count += bytes.length;
        }

        @Override
        public void withByte(byte b) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

