/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.generator;

import java.io.IOException;
import java.io.InputStream;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.io.netty.buffer.ByteBuf;

public final class InputStreamBodyGenerator
implements BodyGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamBody.class);
    private final InputStream inputStream;

    public InputStreamBodyGenerator(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public Body createBody() {
        return new InputStreamBody(this.inputStream);
    }

    private class InputStreamBody
    implements Body {
        private final InputStream inputStream;
        private byte[] chunk;

        private InputStreamBody(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public Body.BodyState transferTo(ByteBuf target) throws IOException {
            this.chunk = new byte[target.writableBytes() - 10];
            int read = -1;
            boolean write = false;
            try {
                read = this.inputStream.read(this.chunk);
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to read", ex);
            }
            if (read > 0) {
                target.writeBytes(this.chunk, 0, read);
                write = true;
            }
            return write ? Body.BodyState.CONTINUE : Body.BodyState.STOP;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }
    }
}

