/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.ws;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketByteFragmentListener;
import org.asynchttpclient.ws.WebSocketByteListener;
import org.asynchttpclient.ws.WebSocketCloseCodeReasonListener;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketPingListener;
import org.asynchttpclient.ws.WebSocketPongListener;
import org.asynchttpclient.ws.WebSocketTextFragmentListener;
import org.asynchttpclient.ws.WebSocketTextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.io.netty.buffer.Unpooled;
import shaded.io.netty.channel.Channel;
import shaded.io.netty.channel.ChannelFutureListener;
import shaded.io.netty.handler.codec.http.HttpHeaders;
import shaded.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import shaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import shaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;

public class NettyWebSocket
implements WebSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyWebSocket.class);
    protected final Channel channel;
    protected final HttpHeaders upgradeHeaders;
    protected final Collection<WebSocketListener> listeners;
    protected final int maxBufferSize;
    private int bufferSize;
    private List<byte[]> _fragments;
    private volatile boolean interestedInByteMessages;
    private volatile boolean interestedInTextMessages;

    public NettyWebSocket(Channel channel, HttpHeaders upgradeHeaders, AsyncHttpClientConfig config) {
        this(channel, upgradeHeaders, config, new ConcurrentLinkedQueue<WebSocketListener>());
    }

    public NettyWebSocket(Channel channel, HttpHeaders upgradeHeaders, AsyncHttpClientConfig config, Collection<WebSocketListener> listeners) {
        this.channel = channel;
        this.upgradeHeaders = upgradeHeaders;
        this.listeners = listeners;
        this.maxBufferSize = config.getWebSocketMaxBufferSize();
    }

    @Override
    public HttpHeaders getUpgradeHeaders() {
        return this.upgradeHeaders;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.remoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.localAddress();
    }

    @Override
    public WebSocket sendMessage(byte[] message) {
        this.channel.writeAndFlush(new BinaryWebSocketFrame(Unpooled.wrappedBuffer(message)));
        return this;
    }

    @Override
    public WebSocket stream(byte[] fragment, boolean last) {
        this.channel.writeAndFlush(new BinaryWebSocketFrame(last, 0, Unpooled.wrappedBuffer(fragment)));
        return this;
    }

    @Override
    public WebSocket stream(byte[] fragment, int offset, int len, boolean last) {
        this.channel.writeAndFlush(new BinaryWebSocketFrame(last, 0, Unpooled.wrappedBuffer(fragment, offset, len)));
        return this;
    }

    @Override
    public WebSocket sendMessage(String message) {
        this.channel.writeAndFlush(new TextWebSocketFrame(message));
        return this;
    }

    @Override
    public WebSocket stream(String fragment, boolean last) {
        this.channel.writeAndFlush(new TextWebSocketFrame(last, 0, fragment));
        return this;
    }

    @Override
    public WebSocket sendPing(byte[] payload) {
        this.channel.writeAndFlush(new PingWebSocketFrame(Unpooled.wrappedBuffer(payload)));
        return this;
    }

    @Override
    public WebSocket sendPong(byte[] payload) {
        this.channel.writeAndFlush(new PongWebSocketFrame(Unpooled.wrappedBuffer(payload)));
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        if (this.channel.isOpen()) {
            this.onClose(1000, "Normal closure; the connection successfully completed whatever purpose for which it was created.");
            this.listeners.clear();
            this.channel.writeAndFlush(new CloseWebSocketFrame()).addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void close(int statusCode, String reason) {
        this.onClose(statusCode, reason);
        this.listeners.clear();
    }

    public void onError(Throwable t) {
        for (WebSocketListener listener : this.listeners) {
            try {
                listener.onError(t);
            }
            catch (Throwable t2) {
                LOGGER.error("WebSocketListener.onError crash", t2);
            }
        }
    }

    public void onClose(int code, String reason) {
        for (WebSocketListener l : this.listeners) {
            try {
                if (l instanceof WebSocketCloseCodeReasonListener) {
                    ((WebSocketCloseCodeReasonListener)WebSocketCloseCodeReasonListener.class.cast(l)).onClose(this, code, reason);
                }
                l.onClose(this);
            }
            catch (Throwable t) {
                l.onError(t);
            }
        }
    }

    public String toString() {
        return "NettyWebSocket{channel=" + this.channel + '}';
    }

    private boolean hasWebSocketByteListener() {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketByteListener)) continue;
            return true;
        }
        return false;
    }

    private boolean hasWebSocketTextListener() {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketTextListener)) continue;
            return true;
        }
        return false;
    }

    @Override
    public WebSocket addWebSocketListener(WebSocketListener l) {
        this.listeners.add(l);
        this.interestedInByteMessages = this.interestedInByteMessages || l instanceof WebSocketByteListener;
        this.interestedInTextMessages = this.interestedInTextMessages || l instanceof WebSocketTextListener;
        return this;
    }

    @Override
    public WebSocket removeWebSocketListener(WebSocketListener l) {
        this.listeners.remove(l);
        if (l instanceof WebSocketByteListener) {
            this.interestedInByteMessages = this.hasWebSocketByteListener();
        }
        if (l instanceof WebSocketTextListener) {
            this.interestedInTextMessages = this.hasWebSocketTextListener();
        }
        return this;
    }

    private List<byte[]> fragments() {
        if (this._fragments == null) {
            this._fragments = new ArrayList<byte[]>(2);
        }
        return this._fragments;
    }

    private void bufferFragment(byte[] buffer) {
        this.bufferSize += buffer.length;
        if (this.bufferSize > this.maxBufferSize) {
            this.onError(new Exception("Exceeded Netty Web Socket maximum buffer size of " + this.maxBufferSize));
            this.reset();
            this.close();
        } else {
            this.fragments().add(buffer);
        }
    }

    private void reset() {
        this.fragments().clear();
        this.bufferSize = 0;
    }

    private void notifyByteListeners(byte[] message) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketByteListener)) continue;
            ((WebSocketByteListener)WebSocketByteListener.class.cast(listener)).onMessage(message);
        }
    }

    private void notifyTextListeners(byte[] bytes) {
        String message = new String(bytes, StandardCharsets.UTF_8);
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketTextListener)) continue;
            ((WebSocketTextListener)WebSocketTextListener.class.cast(listener)).onMessage(message);
        }
    }

    public void onBinaryFragment(HttpResponseBodyPart part) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketByteFragmentListener)) continue;
            ((WebSocketByteFragmentListener)WebSocketByteFragmentListener.class.cast(listener)).onFragment(part);
        }
        if (this.interestedInByteMessages) {
            byte[] fragment = part.getBodyPartBytes();
            if (part.isLast()) {
                if (this.bufferSize == 0) {
                    this.notifyByteListeners(fragment);
                } else {
                    this.bufferFragment(fragment);
                    this.notifyByteListeners(this.fragmentsBytes());
                }
                this.reset();
            } else {
                this.bufferFragment(fragment);
            }
        }
    }

    private byte[] fragmentsBytes() {
        ByteArrayOutputStream os = new ByteArrayOutputStream(this.bufferSize);
        for (byte[] bytes : this._fragments) {
            try {
                os.write(bytes);
            }
            catch (IOException iOException) {}
        }
        return os.toByteArray();
    }

    public void onTextFragment(HttpResponseBodyPart part) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketTextFragmentListener)) continue;
            ((WebSocketTextFragmentListener)WebSocketTextFragmentListener.class.cast(listener)).onFragment(part);
        }
        if (this.interestedInTextMessages) {
            byte[] fragment = part.getBodyPartBytes();
            if (part.isLast()) {
                if (this.bufferSize == 0) {
                    this.notifyTextListeners(fragment);
                } else {
                    this.bufferFragment(fragment);
                    this.notifyTextListeners(this.fragmentsBytes());
                }
                this.reset();
            } else {
                this.bufferFragment(fragment);
            }
        }
    }

    public void onPing(HttpResponseBodyPart part) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketPingListener)) continue;
            ((WebSocketPingListener)WebSocketPingListener.class.cast(listener)).onPing(part.getBodyPartBytes());
        }
    }

    public void onPong(HttpResponseBodyPart part) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketPongListener)) continue;
            ((WebSocketPongListener)WebSocketPongListener.class.cast(listener)).onPong(part.getBodyPartBytes());
        }
    }
}

