/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.ssl;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.netty.ssl.SslEngineFactoryBase;
import shaded.io.netty.buffer.ByteBufAllocator;
import shaded.io.netty.handler.ssl.SslContext;
import shaded.io.netty.handler.ssl.SslContextBuilder;
import shaded.io.netty.handler.ssl.SslProvider;
import shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;

public class DefaultSslEngineFactory
extends SslEngineFactoryBase {
    private final SslContext sslContext;

    public DefaultSslEngineFactory(AsyncHttpClientConfig config) throws SSLException {
        this.sslContext = this.getSslContext(config);
    }

    private SslContext getSslContext(AsyncHttpClientConfig config) throws SSLException {
        if (config.getSslContext() != null) {
            return config.getSslContext();
        }
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(config.isUseOpenSsl() ? SslProvider.OPENSSL : SslProvider.JDK).sessionCacheSize(config.getSslSessionCacheSize()).sessionTimeout(config.getSslSessionTimeout());
        if (config.isAcceptAnyCertificate()) {
            sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        return sslContextBuilder.build();
    }

    @Override
    public SSLEngine newSslEngine(AsyncHttpClientConfig config, String peerHost, int peerPort) {
        SSLEngine sslEngine = this.sslContext.newEngine(ByteBufAllocator.DEFAULT, peerHost, peerPort);
        this.configureSslEngine(sslEngine, config);
        return sslEngine;
    }
}

