/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import java.io.IOException;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.request.ProgressListener;
import org.asynchttpclient.netty.request.body.BodyChunkedInput;
import org.asynchttpclient.netty.request.body.BodyFileRegion;
import org.asynchttpclient.netty.request.body.NettyBody;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.RandomAccessBody;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.FeedListener;
import org.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import org.asynchttpclient.request.body.generator.ReactiveStreamsBodyGenerator;
import org.asynchttpclient.util.MiscUtils;
import shaded.io.netty.channel.Channel;
import shaded.io.netty.channel.ChannelFuture;
import shaded.io.netty.channel.ChannelProgressiveFuture;
import shaded.io.netty.handler.codec.http.LastHttpContent;
import shaded.io.netty.handler.stream.ChunkedWriteHandler;

public class NettyBodyBody
implements NettyBody {
    private final Body body;
    private final AsyncHttpClientConfig config;

    public NettyBodyBody(Body body, AsyncHttpClientConfig config) {
        this.body = body;
        this.config = config;
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public long getContentLength() {
        return this.body.getContentLength();
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) throws IOException {
        Object msg;
        if (this.body instanceof RandomAccessBody && !ChannelManager.isSslHandlerConfigured(channel.pipeline()) && !this.config.isDisableZeroCopy()) {
            msg = new BodyFileRegion((RandomAccessBody)this.body);
        } else {
            msg = new BodyChunkedInput(this.body);
            BodyGenerator bg = future.getTargetRequest().getBodyGenerator();
            if (bg instanceof FeedableBodyGenerator && !(bg instanceof ReactiveStreamsBodyGenerator)) {
                final ChunkedWriteHandler chunkedWriteHandler = channel.pipeline().get(ChunkedWriteHandler.class);
                ((FeedableBodyGenerator)FeedableBodyGenerator.class.cast(bg)).setListener(new FeedListener(){

                    @Override
                    public void onContentAdded() {
                        chunkedWriteHandler.resumeTransfer();
                    }

                    @Override
                    public void onError(Throwable t) {
                    }
                });
            }
        }
        ChannelFuture writeFuture = channel.write(msg, channel.newProgressivePromise());
        writeFuture.addListener(new ProgressListener(future.getAsyncHandler(), future, false, this.getContentLength()){

            @Override
            public void operationComplete(ChannelProgressiveFuture cf) {
                MiscUtils.closeSilently(NettyBodyBody.this.body);
                super.operationComplete(cf);
            }
        });
        channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
    }
}

