/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler.intercept;

import java.util.List;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.ChannelState;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.ntlm.NtlmEngine;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.spnego.SpnegoEngine;
import org.asynchttpclient.spnego.SpnegoEngineException;
import org.asynchttpclient.util.AuthenticatorUtils;
import org.asynchttpclient.util.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.io.netty.channel.Channel;
import shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import shaded.io.netty.handler.codec.http.HttpHeaders;
import shaded.io.netty.handler.codec.http.HttpRequest;
import shaded.io.netty.handler.codec.http.HttpResponse;

public class ProxyUnauthorized407Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyUnauthorized407Interceptor.class);
    private final ChannelManager channelManager;
    private final NettyRequestSender requestSender;

    public ProxyUnauthorized407Interceptor(ChannelManager channelManager, NettyRequestSender requestSender) {
        this.channelManager = channelManager;
        this.requestSender = requestSender;
    }

    public boolean exitAfterHandling407(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, ProxyServer proxyServer, HttpRequest httpRequest) {
        if (future.getInProxyAuth().getAndSet(true)) {
            LOGGER.info("Can't handle 407 as auth was already performed");
            return false;
        }
        Realm proxyRealm = future.getProxyRealm();
        if (proxyRealm == null) {
            LOGGER.info("Can't handle 407 as there's no proxyRealm");
            return false;
        }
        List<String> proxyAuthHeaders = response.headers().getAll("Proxy-Authenticate");
        if (proxyAuthHeaders.isEmpty()) {
            LOGGER.info("Can't handle 407 as response doesn't contain Proxy-Authenticate headers");
            return false;
        }
        future.setChannelState(ChannelState.NEW);
        HttpHeaders requestHeaders = new DefaultHttpHeaders(false).add(request.getHeaders());
        switch (proxyRealm.getScheme()) {
            case BASIC: {
                if (AuthenticatorUtils.getHeaderWithPrefix(proxyAuthHeaders, "Basic") == null) {
                    LOGGER.info("Can't handle 407 with Basic realm as Proxy-Authenticate headers don't match");
                    return false;
                }
                if (proxyRealm.isUsePreemptiveAuth()) {
                    LOGGER.info("Can't handle 407 with Basic realm as auth was preemptive and already performed");
                    return false;
                }
                Realm newBasicRealm = Dsl.realm(proxyRealm).setUsePreemptiveAuth(true).build();
                future.setProxyRealm(newBasicRealm);
                break;
            }
            case DIGEST: {
                String digestHeader = AuthenticatorUtils.getHeaderWithPrefix(proxyAuthHeaders, "Digest");
                if (digestHeader == null) {
                    LOGGER.info("Can't handle 407 with Digest realm as Proxy-Authenticate headers don't match");
                    return false;
                }
                Realm newDigestRealm = Dsl.realm(proxyRealm).setUri(request.getUri()).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseProxyAuthenticateHeader(digestHeader).build();
                future.setProxyRealm(newDigestRealm);
                break;
            }
            case NTLM: {
                String ntlmHeader = AuthenticatorUtils.getHeaderWithPrefix(proxyAuthHeaders, "NTLM");
                if (ntlmHeader == null) {
                    LOGGER.info("Can't handle 407 with NTLM realm as Proxy-Authenticate headers don't match");
                    return false;
                }
                this.ntlmProxyChallenge(ntlmHeader, request, requestHeaders, proxyRealm, future);
                Realm newNtlmRealm = Dsl.realm(proxyRealm).setUsePreemptiveAuth(true).build();
                future.setProxyRealm(newNtlmRealm);
                break;
            }
            case KERBEROS: 
            case SPNEGO: {
                if (AuthenticatorUtils.getHeaderWithPrefix(proxyAuthHeaders, "Negotiate") == null) {
                    LOGGER.info("Can't handle 407 with Kerberos or Spnego realm as Proxy-Authenticate headers don't match");
                    return false;
                }
                try {
                    this.kerberosProxyChallenge(channel, proxyAuthHeaders, request, proxyServer, proxyRealm, requestHeaders, future);
                    break;
                }
                catch (SpnegoEngineException e) {
                    String ntlmHeader2 = AuthenticatorUtils.getHeaderWithPrefix(proxyAuthHeaders, "NTLM");
                    if (ntlmHeader2 != null) {
                        LOGGER.warn("Kerberos/Spnego proxy auth failed, proceeding with NTLM");
                        this.ntlmProxyChallenge(ntlmHeader2, request, requestHeaders, proxyRealm, future);
                        Realm newNtlmRealm2 = Dsl.realm(proxyRealm).setScheme(Realm.AuthScheme.NTLM).setUsePreemptiveAuth(true).build();
                        future.setProxyRealm(newNtlmRealm2);
                        break;
                    }
                    this.requestSender.abort(channel, future, e);
                    return false;
                }
            }
            default: {
                throw new IllegalStateException("Invalid Authentication scheme " + (Object)((Object)proxyRealm.getScheme()));
            }
        }
        RequestBuilder nextRequestBuilder = (RequestBuilder)new RequestBuilder(future.getCurrentRequest()).setHeaders(requestHeaders);
        if (future.getCurrentRequest().getUri().isSecured()) {
            nextRequestBuilder.setMethod(HttpConstants.Methods.CONNECT);
        }
        Request nextRequest = nextRequestBuilder.build();
        LOGGER.debug("Sending proxy authentication to {}", (Object)request.getUri());
        if (future.isKeepAlive() && !HttpHeaders.isTransferEncodingChunked(httpRequest) && !HttpHeaders.isTransferEncodingChunked(response)) {
            future.setConnectAllowed(true);
            future.setReuseChannel(true);
            this.requestSender.drainChannelAndExecuteNextRequest(channel, future, nextRequest);
        } else {
            this.channelManager.closeChannel(channel);
            this.requestSender.sendNextRequest(nextRequest, future);
        }
        return true;
    }

    private void kerberosProxyChallenge(Channel channel, List<String> proxyAuth, Request request, ProxyServer proxyServer, Realm proxyRealm, HttpHeaders headers, NettyResponseFuture<?> future) throws SpnegoEngineException {
        String challengeHeader = SpnegoEngine.instance().generateToken(proxyServer.getHost());
        headers.set("Proxy-Authorization", (Object)("Negotiate " + challengeHeader));
    }

    private void ntlmProxyChallenge(String authenticateHeader, Request request, HttpHeaders requestHeaders, Realm proxyRealm, NettyResponseFuture<?> future) {
        if (authenticateHeader.equals("NTLM")) {
            String challengeHeader = NtlmEngine.INSTANCE.generateType1Msg();
            requestHeaders.set("Proxy-Authorization", (Object)("NTLM " + challengeHeader));
            future.getInProxyAuth().set(false);
        } else {
            String serverChallenge = authenticateHeader.substring("NTLM ".length()).trim();
            String challengeHeader = NtlmEngine.INSTANCE.generateType3Msg(proxyRealm.getPrincipal(), proxyRealm.getPassword(), proxyRealm.getNtlmDomain(), proxyRealm.getNtlmHost(), serverChallenge);
            requestHeaders.set("Proxy-Authorization", (Object)("NTLM " + challengeHeader));
        }
    }
}

