/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler;

import com.typesafe.netty.HandlerPublisher;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.io.netty.channel.Channel;
import shaded.io.netty.util.concurrent.EventExecutor;

public class StreamedResponsePublisher
extends HandlerPublisher<HttpResponseBodyPart> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ChannelManager channelManager;
    private final NettyResponseFuture<?> future;
    private final Channel channel;

    public StreamedResponsePublisher(EventExecutor executor, ChannelManager channelManager, NettyResponseFuture<?> future, Channel channel) {
        super(executor, HttpResponseBodyPart.class);
        this.channelManager = channelManager;
        this.future = future;
        this.channel = channel;
    }

    protected void cancelled() {
        this.logger.debug("Subscriber cancelled, ignoring the rest of the body");
        this.channelManager.drainChannelAndOffer(this.channel, this.future);
        this.channel.pipeline().remove(StreamedResponsePublisher.class);
        try {
            this.future.done();
        }
        catch (Exception t) {
            this.logger.debug(t.getMessage(), t);
        }
    }

    NettyResponseFuture<?> future() {
        return this.future;
    }
}

