/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.asynchttpclient.netty.channel.Channels;
import shaded.io.netty.channel.Channel;
import shaded.io.netty.channel.group.ChannelGroupFuture;
import shaded.io.netty.channel.group.DefaultChannelGroup;
import shaded.io.netty.util.concurrent.GlobalEventExecutor;

public class CleanupChannelGroup
extends DefaultChannelGroup {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public CleanupChannelGroup() {
        super(GlobalEventExecutor.INSTANCE);
    }

    public CleanupChannelGroup(String name) {
        super(name, GlobalEventExecutor.INSTANCE);
    }

    @Override
    public ChannelGroupFuture close() {
        this.lock.writeLock().lock();
        try {
            if (!this.closed.getAndSet(true)) {
                ChannelGroupFuture channelGroupFuture = super.close();
                return channelGroupFuture;
            }
            throw new UnsupportedOperationException("CleanupChannelGroup already closed");
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean add(Channel channel) {
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                Channels.silentlyCloseChannel(channel);
                boolean bl = false;
                return bl;
            }
            boolean bl = super.add(channel);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

