/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import org.asynchttpclient.netty.DiscardEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.io.netty.channel.Channel;
import shaded.io.netty.channel.ChannelId;
import shaded.io.netty.channel.DefaultChannelId;
import shaded.io.netty.util.Attribute;
import shaded.io.netty.util.AttributeKey;

public class Channels {
    private static final Logger LOGGER = LoggerFactory.getLogger(Channels.class);
    private static final AttributeKey<Object> DEFAULT_ATTRIBUTE = AttributeKey.valueOf("default");
    private static final AttributeKey<ChannelId> CHANNEL_ID_ATTRIBUTE = AttributeKey.valueOf("channelId");

    public static Object getAttribute(Channel channel) {
        Attribute<Object> attr = channel.attr(DEFAULT_ATTRIBUTE);
        return attr != null ? attr.get() : null;
    }

    public static void setAttribute(Channel channel, Object o) {
        channel.attr(DEFAULT_ATTRIBUTE).set(o);
    }

    public static void setDiscard(Channel channel) {
        Channels.setAttribute(channel, (Object)DiscardEvent.INSTANCE);
    }

    public static boolean isChannelValid(Channel channel) {
        return channel != null && channel.isActive();
    }

    public static ChannelId getChannelId(Channel channel) {
        Attribute<ChannelId> attr = channel.attr(CHANNEL_ID_ATTRIBUTE);
        return attr != null ? attr.get() : null;
    }

    public static void initChannelId(Channel channel) {
        channel.attr(CHANNEL_ID_ATTRIBUTE).set(new DefaultChannelId());
    }

    public static void silentlyCloseChannel(Channel channel) {
        try {
            if (channel != null && channel.isActive()) {
                channel.close();
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Failed to close channel", t);
        }
    }
}

