/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.buildah.core.commands;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GlobalParametersSupport {
    private static final String ALSOLOGTOSTDERR = "--alsologtostderr";
    private static final String LOGBACKTRACEAT = "--log_backtrace_at";
    private static final String LOGDIR = "--log_dir";
    private static final String LOGTOSTDERR = "--logtostderr";
    private static final String SKIPCONNECTIONCHECK = "--skip-connection-check";
    private static final String STDERRTHRESHOLD = "--stderrthreshold";
    private static final String V = "--v";
    private static final String VMODULE = "--vmodule";
    private Boolean alsologtostderr;
    private Integer log_backtrace_at;
    private String log_dir;
    private Boolean logtostderr;
    private Boolean skipconnectioncheck;
    private Integer stderrthreshold;
    private Integer v;
    private List<String> vmodule;
    private List<String> extraCommands;

    public List<String> getCliCommand() {
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.alsologtostderr != null && this.alsologtostderr.booleanValue()) {
            arguments.add(ALSOLOGTOSTDERR);
        }
        if (this.log_backtrace_at != null) {
            arguments.add(LOGBACKTRACEAT);
            arguments.add(Integer.toString(this.log_backtrace_at));
        }
        if (this.log_dir != null) {
            arguments.add(LOGDIR);
            arguments.add(this.log_dir);
        }
        if (this.logtostderr != null && this.logtostderr.booleanValue()) {
            arguments.add(LOGTOSTDERR);
        }
        if (this.skipconnectioncheck != null && this.skipconnectioncheck.booleanValue()) {
            arguments.add(SKIPCONNECTIONCHECK);
        }
        if (this.stderrthreshold != null) {
            arguments.add(STDERRTHRESHOLD);
            arguments.add(Integer.toString(this.stderrthreshold));
        }
        if (this.v != null) {
            arguments.add(V);
            arguments.add(Integer.toString(this.v));
        }
        if (this.vmodule != null && this.vmodule.size() > 0) {
            arguments.add(VMODULE);
            arguments.add(this.toCsv(this.vmodule));
        }
        if (this.extraCommands != null) {
            arguments.addAll(this.extraCommands);
        }
        return arguments;
    }

    private String toCsv(List<String> args) {
        return args.stream().collect(Collectors.joining(", "));
    }

    public static abstract class Builder<T> {
        private GlobalParametersSupport globalParametersSupport = new GlobalParametersSupport();
        private Class<T> typeOfT = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

        public T withAlsoLogToStderr() {
            this.globalParametersSupport.alsologtostderr = true;
            Type type = ((ParameterizedType)this.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
            return this.typeOfT.cast(this);
        }

        public T withLogBacktraceAt(Integer logBacktraceAt) {
            this.globalParametersSupport.log_backtrace_at = logBacktraceAt;
            return this.typeOfT.cast(this);
        }

        public T withLogDir(String log_dir) {
            this.globalParametersSupport.log_dir = log_dir;
            return this.typeOfT.cast(this);
        }

        public T withLogToStderr() {
            this.globalParametersSupport.logtostderr = true;
            return this.typeOfT.cast(this);
        }

        public T withSkipConnectionCheck() {
            this.globalParametersSupport.skipconnectioncheck = true;
            return this.typeOfT.cast(this);
        }

        public T withStderrThreshold(Integer threshold) {
            this.globalParametersSupport.stderrthreshold = threshold;
            return this.typeOfT.cast(this);
        }

        public T withV(Integer v) {
            this.globalParametersSupport.v = v;
            return this.typeOfT.cast(this);
        }

        public T withVModule(List<String> vmodule) {
            this.globalParametersSupport.vmodule = vmodule;
            return this.typeOfT.cast(this);
        }

        public T withExtraArguments(List<String> extraArguments) {
            this.globalParametersSupport.extraCommands = extraArguments;
            return this.typeOfT.cast(this);
        }

        protected GlobalParametersSupport buildGlobalParameters() {
            return this.globalParametersSupport;
        }
    }
}

