/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.buildah.core.commands;

import io.jshift.buildah.core.CliExecutor;
import io.jshift.buildah.core.commands.AbstractRunnableCommand;
import io.jshift.buildah.core.commands.GlobalParametersSupport;
import java.util.ArrayList;
import java.util.List;

public class BuildahRemoveImageCommand
extends AbstractRunnableCommand<Void> {
    private static final String COMMAND_NAME = "rmi";
    private static final String ALL = "--all";
    private static final String PRUNE = "--prune";
    private static final String FORCE = "--force";
    private String imageId;
    private Boolean removeAll = Boolean.FALSE;
    private Boolean prune = Boolean.FALSE;
    private Boolean force = Boolean.FALSE;
    private GlobalParametersSupport globalParametersSupport;

    protected BuildahRemoveImageCommand(CliExecutor buildahExecutor) {
        super(buildahExecutor);
    }

    @Override
    public List<String> getCliCommand() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(COMMAND_NAME);
        if (this.imageId != null) {
            arguments.add(this.imageId);
        }
        if (this.removeAll != null && this.removeAll.booleanValue()) {
            arguments.add(ALL);
        }
        if (this.prune != null && this.prune.booleanValue()) {
            arguments.add(PRUNE);
        }
        if (this.force != null && this.force.booleanValue()) {
            arguments.add(FORCE);
        }
        return arguments;
    }

    public static class Builder
    extends GlobalParametersSupport.Builder<Builder> {
        private BuildahRemoveImageCommand buildahRemoveImageCommand;

        public Builder(CliExecutor buildahExecutor) {
            this.buildahRemoveImageCommand = new BuildahRemoveImageCommand(buildahExecutor);
        }

        public Builder image(String imageId) {
            this.buildahRemoveImageCommand.imageId = imageId;
            return this;
        }

        public Builder all(boolean removeAll) {
            this.buildahRemoveImageCommand.removeAll = removeAll;
            return this;
        }

        public Builder prune(boolean prune) {
            this.buildahRemoveImageCommand.prune = prune;
            return this;
        }

        public Builder force(boolean force) {
            this.buildahRemoveImageCommand.force = force;
            return this;
        }

        public BuildahRemoveImageCommand build() {
            this.buildahRemoveImageCommand.globalParametersSupport = this.buildGlobalParameters();
            return this.buildahRemoveImageCommand;
        }
    }
}

