/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.buildah.core.commands;

import io.jshift.buildah.core.CliExecutor;
import io.jshift.buildah.core.commands.AbstractRunnableCommand;
import io.jshift.buildah.core.commands.GlobalParametersSupport;
import java.util.ArrayList;
import java.util.List;

public class BuildahPushCommand
extends AbstractRunnableCommand<Void> {
    private static final String COMMAND_NAME = "push";
    private static final String CREDS = "--creds";
    private static final String TLS_VERIFY = "--tls-verify=false";
    private static final String CERT_DIR = "--cert-dir";
    private static final String AUTH_FILE = "--authfile";
    private String imageId;
    private String registry;
    private String credentials;
    private Boolean tlsVerify = Boolean.TRUE;
    private String certDir;
    private String authfile;
    private GlobalParametersSupport globalParametersSupport;

    protected BuildahPushCommand(CliExecutor buildahExecutor, String imageId) {
        super(buildahExecutor);
        this.imageId = imageId;
    }

    @Override
    public List<String> getCliCommand() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(COMMAND_NAME);
        if (this.certDir != null) {
            arguments.add(CERT_DIR);
            arguments.add(this.certDir);
        }
        if (this.authfile != null) {
            arguments.add(AUTH_FILE);
            arguments.add(this.authfile);
        }
        if (this.tlsVerify != null && this.tlsVerify.booleanValue()) {
            arguments.add(TLS_VERIFY);
        }
        if (this.credentials != null) {
            arguments.add(CREDS);
            arguments.add(this.credentials);
        }
        arguments.add(this.imageId);
        if (this.registry != null) {
            arguments.add(this.registry);
        }
        return arguments;
    }

    public static class Builder
    extends GlobalParametersSupport.Builder<Builder> {
        private BuildahPushCommand buildahPushCommand;

        public Builder(CliExecutor buildahExecutor, String imageId) {
            this.buildahPushCommand = new BuildahPushCommand(buildahExecutor, imageId);
        }

        public Builder tlsVerify(boolean tlsVerify) {
            this.buildahPushCommand.tlsVerify = tlsVerify;
            return this;
        }

        public Builder creds(String credentials) {
            this.buildahPushCommand.credentials = credentials;
            return this;
        }

        public Builder registry(String registry) {
            this.buildahPushCommand.registry = registry;
            return this;
        }

        public Builder authfile(String authfile) {
            this.buildahPushCommand.authfile = authfile;
            return this;
        }

        public Builder certDir(String certDir) {
            this.buildahPushCommand.certDir = certDir;
            return this;
        }

        public BuildahPushCommand build() {
            this.buildahPushCommand.globalParametersSupport = this.buildGlobalParameters();
            return this.buildahPushCommand;
        }
    }
}

