/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.buildah.core.commands;

import io.jshift.buildah.core.CliExecutor;
import io.jshift.buildah.core.commands.AbstractRunnableCommand;
import io.jshift.buildah.core.commands.GlobalParametersSupport;
import java.util.ArrayList;
import java.util.List;

public class BuildahPullCommand
extends AbstractRunnableCommand<Void> {
    private static final String COMMAND_NAME = "pull";
    private static final String CERT_DIR = "--cert-dir";
    private static final String CREDENTIALS = "--creds";
    private static final String AUTH_FILE = "--authfile";
    private static final String TLS_VERIFY = "--tls-verify=false";
    private String imageName;
    private String certDir;
    private String credentials;
    private String authfile;
    private Boolean tlsVerify = Boolean.TRUE;
    private GlobalParametersSupport globalParametersSupport;

    protected BuildahPullCommand(CliExecutor buildahExecutor, String imageName) {
        super(buildahExecutor);
        this.imageName = imageName;
    }

    @Override
    public List<String> getCliCommand() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(COMMAND_NAME);
        if (this.authfile != null) {
            arguments.add(AUTH_FILE);
            arguments.add(this.authfile);
        }
        if (this.certDir != null) {
            arguments.add(CERT_DIR);
            arguments.add(this.certDir);
        }
        if (this.tlsVerify != null && this.tlsVerify.booleanValue()) {
            arguments.add(TLS_VERIFY);
        }
        if (this.credentials != null) {
            arguments.add(CREDENTIALS);
            arguments.add(this.credentials);
        }
        arguments.add(this.imageName);
        return arguments;
    }

    public static class Builder
    extends GlobalParametersSupport.Builder<Builder> {
        private BuildahPullCommand buildahPullCommand;

        public Builder(String imageName, CliExecutor buildahExecutor) {
            this.buildahPullCommand = new BuildahPullCommand(buildahExecutor, imageName);
        }

        public Builder tlsVerification(boolean tlsVerify) {
            this.buildahPullCommand.tlsVerify = tlsVerify;
            return this;
        }

        public Builder authfile(String authfile) {
            this.buildahPullCommand.authfile = authfile;
            return this;
        }

        public Builder certDir(String certDir) {
            this.buildahPullCommand.certDir = certDir;
            return this;
        }

        public Builder credentials(String credentials) {
            this.buildahPullCommand.credentials = credentials;
            return this;
        }

        public BuildahPullCommand build() {
            this.buildahPullCommand.globalParametersSupport = this.buildGlobalParameters();
            return this.buildahPullCommand;
        }
    }
}

