/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.buildah.core.commands;

import io.jshift.buildah.core.CliExecutor;
import io.jshift.buildah.core.commands.AbstractRunnableCommand;
import io.jshift.buildah.core.commands.GlobalParametersSupport;
import java.util.ArrayList;
import java.util.List;

public class BuildahLoginCommand
extends AbstractRunnableCommand<Void> {
    private static final String COMMAND_NAME = "login";
    private static final String USERNAME = "-u";
    private static final String PASSWORD = "-p";
    private static final String TLS_VERIFY = "--tls-verify=false";
    private String registryName;
    private String username;
    private String password;
    private Boolean tlsVerify = Boolean.TRUE;
    private GlobalParametersSupport globalParametersSupport;

    protected BuildahLoginCommand(CliExecutor buildahExecutor, String registryName) {
        super(buildahExecutor);
        this.registryName = registryName;
    }

    @Override
    public List<String> getCliCommand() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(COMMAND_NAME);
        if (this.tlsVerify != null && this.tlsVerify.booleanValue()) {
            arguments.add(TLS_VERIFY);
        }
        if (this.username != null) {
            arguments.add(USERNAME);
            arguments.add(this.username);
        }
        if (this.password != null) {
            arguments.add(PASSWORD);
            arguments.add(this.password);
        }
        arguments.add(this.registryName);
        return arguments;
    }

    public static class Builder
    extends GlobalParametersSupport.Builder<Builder> {
        private BuildahLoginCommand buildahLoginCommand;

        public Builder(String registryName, CliExecutor buildahExecutor) {
            this.buildahLoginCommand = new BuildahLoginCommand(buildahExecutor, registryName);
        }

        public Builder tlsVerify(boolean tlsVerify) {
            this.buildahLoginCommand.tlsVerify = tlsVerify;
            return this;
        }

        public Builder username(String username) {
            this.buildahLoginCommand.username = username;
            return this;
        }

        public Builder password(String password) {
            this.buildahLoginCommand.password = password;
            return this;
        }

        public BuildahLoginCommand build() {
            this.buildahLoginCommand.globalParametersSupport = this.buildGlobalParameters();
            return this.buildahLoginCommand;
        }
    }
}

