/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.buildah.core.commands;

import io.jshift.buildah.core.CliExecutor;
import io.jshift.buildah.core.commands.AbstractRunnableCommand;
import io.jshift.buildah.core.commands.GlobalParametersSupport;
import java.util.ArrayList;
import java.util.List;

public class BuildahCopyCommand
extends AbstractRunnableCommand<Void> {
    private static final String COMMAND_NAME = "copy";
    private static final String CHOWN = "--chown";
    private String containerId;
    private String source;
    private String destination;
    private String chown;
    private GlobalParametersSupport globalParametersSupport;

    protected BuildahCopyCommand(CliExecutor buildahExecutor, String containerId, String source) {
        super(buildahExecutor);
        this.containerId = containerId;
        this.source = source;
    }

    @Override
    public List<String> getCliCommand() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(COMMAND_NAME);
        if (this.chown != null) {
            arguments.add(CHOWN);
            arguments.add(this.chown);
        }
        arguments.add(this.containerId);
        arguments.add(this.source);
        if (this.destination != null) {
            arguments.add(this.destination);
        }
        return arguments;
    }

    public static class Builder
    extends GlobalParametersSupport.Builder<Builder> {
        private BuildahCopyCommand buildahCopyCommand;

        public Builder(CliExecutor buildahExecutor, String containerId, String source) {
            this.buildahCopyCommand = new BuildahCopyCommand(buildahExecutor, containerId, source);
        }

        public Builder destination(String destination) {
            this.buildahCopyCommand.destination = destination;
            return this;
        }

        public Builder chown(String chown) {
            this.buildahCopyCommand.chown = chown;
            return this;
        }

        public BuildahCopyCommand build() {
            this.buildahCopyCommand.globalParametersSupport = this.buildGlobalParameters();
            return this.buildahCopyCommand;
        }
    }
}

