/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.buildah.core.commands;

import io.jshift.buildah.core.CliExecutor;
import io.jshift.buildah.core.commands.AbstractRunnableCommand;
import io.jshift.buildah.core.commands.GlobalParametersSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BuildahConfigCommand
extends AbstractRunnableCommand<Void> {
    private static final String COMMAND_NAME = "config";
    private static final String AUTHOR = "--author";
    private static final String ENV = "--env";
    private static final String LABEL = "--label";
    private static final String ANNOTATION = "--annotation";
    private static final String VOLUME = "--volume";
    private static final String WORKING_DIR = "--workingdir";
    private static final String PORT = "--port";
    private static final String ENTRYPOINT = "--entrypoint";
    private String author;
    private String containerId;
    private List<String> envList;
    private List<String> labelList;
    private List<String> annotationList;
    private String volumePath;
    private String workingDir;
    private List<String> portList;
    private List<String> entrypointList;
    private GlobalParametersSupport globalParametersSupport;

    protected BuildahConfigCommand(CliExecutor buildahExecutor, String containerId) {
        super(buildahExecutor);
        this.containerId = containerId;
    }

    @Override
    public List<String> getCliCommand() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(COMMAND_NAME);
        if (this.author != null) {
            arguments.add(AUTHOR);
            arguments.add(this.author);
        }
        if (this.envList != null) {
            for (String env : this.envList) {
                arguments.add(ENV);
                arguments.add(env);
            }
        }
        if (this.labelList != null) {
            for (String label : this.labelList) {
                arguments.add(LABEL);
                arguments.add(label);
            }
        }
        if (this.annotationList != null) {
            for (String annotation : this.annotationList) {
                arguments.add(ANNOTATION);
                arguments.add(annotation);
            }
        }
        if (this.volumePath != null) {
            arguments.add(VOLUME);
            arguments.add(this.volumePath);
        }
        if (this.workingDir != null) {
            arguments.add(WORKING_DIR);
            arguments.add(this.workingDir);
        }
        if (this.portList != null) {
            for (String port : this.portList) {
                arguments.add(PORT);
                arguments.add(port);
            }
        }
        if (this.entrypointList != null) {
            arguments.add(ENTRYPOINT);
            String entrypointString = "[";
            entrypointString = entrypointString + this.entrypointList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
            entrypointString = entrypointString + "]";
            arguments.add(entrypointString);
        }
        arguments.add(this.containerId);
        return arguments;
    }

    public static class Builder
    extends GlobalParametersSupport.Builder<Builder> {
        private BuildahConfigCommand buildahConfigCommand;

        public Builder(CliExecutor buildahExecutor, String containerId) {
            this.buildahConfigCommand = new BuildahConfigCommand(buildahExecutor, containerId);
        }

        public Builder authorInfo(String author) {
            this.buildahConfigCommand.author = author;
            return this;
        }

        public Builder env(List<String> envList) {
            this.buildahConfigCommand.envList = envList;
            return this;
        }

        public Builder label(List<String> labelList) {
            this.buildahConfigCommand.labelList = labelList;
            return this;
        }

        public Builder annotation(List<String> annotationList) {
            this.buildahConfigCommand.annotationList = annotationList;
            return this;
        }

        public Builder volume(String volumePath) {
            this.buildahConfigCommand.volumePath = volumePath;
            return this;
        }

        public Builder workingDir(String workingDir) {
            this.buildahConfigCommand.workingDir = workingDir;
            return this;
        }

        public Builder port(List<String> portList) {
            this.buildahConfigCommand.portList = portList;
            return this;
        }

        public Builder entrypoint(List<String> entrypointList) {
            this.buildahConfigCommand.entrypointList = entrypointList;
            return this;
        }

        public BuildahConfigCommand build() {
            this.buildahConfigCommand.globalParametersSupport = this.buildGlobalParameters();
            return this.buildahConfigCommand;
        }
    }
}

